/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.v8.dt.platform.IDependentProject;
import com.e1c.langtool.v8.dt.ui.projecteditor.IExternalProjectSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ExternalProjectSettings
implements IExternalProjectSettings {
    private final List<IDependentProject> projects;
    private final ITranslatingProject translatingProject;
    private final ISettingsEditingContext context;

    public ExternalProjectSettings(ISettingsEditingContext context, ITranslatingProject translatingProject, Collection<? extends IDependentProject> projects) {
        this.context = context;
        this.projects = Lists.newArrayList(projects);
        this.translatingProject = translatingProject;
    }

    @Override
    public void add(IDependentProject project) {
        this.projects.add(project);
        this.context.markDirty();
    }

    @Override
    public void remove(IDependentProject project) {
        this.projects.remove(project);
        this.context.markDirty();
    }

    @Override
    public ITranslatingProject getTranslatingProject() {
        return this.translatingProject;
    }

    @Override
    public Collection<IDependentProject> getAll() {
        return new ArrayList<IDependentProject>(this.projects);
    }
}

