/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.common.FileUtil;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.platform.DependentProject;
import com.e1c.langtool.v8.dt.ui.projecteditor.IExternalProjectSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ExternalProjectUtils {
    private static final String SUFFIX_HELP_FILE_PATH = "html";

    public static void regroupProjects(ISettingsEditingContext context) {
        IExternalProjectSettings settings = context.getExternalProjectSettings();
        HashMap<LanguageKey, IProject> groupedByLanguage = new HashMap<LanguageKey, IProject>();
        context.getTranslateLanguageSettings().getAllLanguages().forEach(lang -> {
            LanguageKey languageKey = new LanguageKey((TranslateLanguage)lang);
            groupedByLanguage.put(languageKey, settings.getTranslatingProject().getProject());
        });
        settings.getAll().forEach(project -> project.getLanguages().forEach(lang -> {
            LanguageKey languageKey = new LanguageKey((TranslateLanguage)lang);
            groupedByLanguage.put(languageKey, project.getSourceProject());
        }));
        HashMultimap groupedProjects = HashMultimap.create();
        groupedByLanguage.forEach((arg_0, arg_1) -> ExternalProjectUtils.lambda$3((Multimap)groupedProjects, arg_0, arg_1));
        ArrayList<DependentProject> newProjects = new ArrayList<DependentProject>();
        for (IProject key : groupedProjects.keySet()) {
            if (groupedProjects.get((Object)key).isEmpty()) continue;
            DependentProject newProject = new DependentProject(settings.getTranslatingProject(), key, groupedProjects.get((Object)key));
            newProjects.add(newProject);
        }
        ArrayList projectsToDelete = Lists.newArrayList(settings.getAll());
        projectsToDelete.forEach(settings::remove);
        newProjects.forEach(settings::add);
    }

    private ExternalProjectUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void moveHtmlFiles(IProject sourceProject, IProject targetProject, Collection<V8TranslateLanguage> languages, IProgressMonitor monitor) throws CoreException {
        if (languages.isEmpty()) {
            return;
        }
        Set<String> helpFileNames = languages.stream().map(language -> String.format("%s.%s", language.getLanguageCode(), SUFFIX_HELP_FILE_PATH)).collect(Collectors.toSet());
        List<IFile> helpFiles = ExternalProjectUtils.findHtmlFiles(sourceProject, helpFileNames);
        for (IFile sourceFile : helpFiles) {
            ExternalProjectUtils.moveHtmlFile(sourceFile, sourceProject, targetProject, monitor);
        }
    }

    private static List<IFile> findHtmlFiles(IProject project, Set<String> helpFileNames) throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (project == null || !project.exists() || !project.isAccessible()) {
            return result;
        }
        ExternalProjectUtils.findHtmlFilesRecursively((IResource)project, result, helpFileNames);
        return result;
    }

    private static void moveHtmlFile(IFile sourceFile, IProject sourceProject, IProject targetProject, IProgressMonitor monitor) throws CoreException {
        IPath sourcePath = sourceFile.getFullPath();
        IPath relativePath = sourcePath.makeRelativeTo(sourceProject.getFullPath());
        IFile targetFile = targetProject.getFile(relativePath);
        FileUtil.moveOrRenameFile((IFile)targetFile, (IFile)sourceFile);
    }

    private static void findHtmlFilesRecursively(IResource resource, final List<IFile> result, final Set<String> helpFileNames) throws CoreException {
        if (!resource.isAccessible()) {
            return;
        }
        resource.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1) {
                    IFile file = (IFile)resource;
                    boolean isHelpFile = helpFileNames.contains(file.getName());
                    if (isHelpFile) {
                        result.add(file);
                    }
                    return false;
                }
                return resource.getType() == 2 || resource.getType() == 4;
            }
        });
    }

    private static /* synthetic */ void lambda$3(Multimap multimap, LanguageKey langKey, IProject projKey) {
        boolean bl = multimap.put((Object)projKey, (Object)langKey.getLanguage());
    }

    private static final class LanguageKey {
        private final TranslateLanguage language;

        public LanguageKey(TranslateLanguage language) {
            this.language = language;
        }

        public TranslateLanguage getLanguage() {
            return this.language;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.language == null ? 0 : this.language.getName().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LanguageKey other = (LanguageKey)obj;
            return !(this.language == null ? other.language != null : !this.language.getName().equals(other.language.getName()));
        }
    }
}

