/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.md.ui.navigator.adapters.CommonNavigatorAdapter;
import com._1c.g5.v8.dt.navigator.adapters.IndexedTopObjectCollectionNavigatorAdapterBase;
import com.e1c.langtool.ui.ExecutionErrorDialog;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.platform.IDependentProject;
import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.e1c.langtool.v8.dt.ui.projecteditor.ExternalProjectUtils;
import com.e1c.langtool.v8.dt.ui.projecteditor.ExternalProjectWizardPage;
import com.e1c.langtool.v8.dt.ui.projecteditor.IExternalProjectSettings;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.NewWizardEditingContext;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ExternalProjectWizard
extends Wizard
implements INewWizard {
    public static final String INTERFACE_LANGUAGES = "interface_languages";
    @Inject
    private IResourceLookup resourceLookup;
    private IDependentProject dependentProject;
    private boolean isNew;
    private boolean saveContextOnFinish = false;
    private ISettingsEditingContext context;
    private ExternalProjectWizardPage page;

    public void init(ISettingsEditingContext context, IDependentProject dependentProject) {
        this.context = context;
        this.isNew = false;
        this.dependentProject = dependentProject;
    }

    public void init(ISettingsEditingContext context) {
        this.context = context;
        this.isNew = true;
        this.dependentProject = null;
    }

    public void addPages() {
        this.page = null;
        this.page = this.dependentProject == null ? new ExternalProjectWizardPage(this.context) : new ExternalProjectWizardPage(this.context, this.dependentProject);
        this.addPage(this.page);
    }

    public boolean performFinish() {
        IDependentProject project = this.page.getData();
        IExternalProjectSettings settings = this.context.getExternalProjectSettings();
        if (this.isNew) {
            settings.add(project);
        } else {
            settings.remove(this.dependentProject);
            settings.add(project);
        }
        ExternalProjectUtils.regroupProjects(this.context);
        if (this.saveContextOnFinish) {
            try {
                this.getContainer().run(true, true, monitor -> {
                    monitor.beginTask(Messages.ExternalProjectWizard_SavingExternalProjectsJobMessage, -1);
                    this.context.doSave(monitor);
                });
            }
            catch (ManifestException | InvocationTargetException e) {
                V8UiPlugin.logError(e);
                ExecutionErrorDialog.openError((Shell)this.getShell(), (String)"Saving the Translated Project was failed", (Throwable)e);
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public IDependentProject getProject() {
        return this.dependentProject;
    }

    public void setProject(IDependentProject project) {
        this.dependentProject = project;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.saveContextOnFinish = true;
        this.setNeedsProgressMonitor(true);
        Object object = selection.getFirstElement();
        if (object instanceof IResource) {
            NewWizardEditingContext editingContext = NewWizardEditingContext.create(((IResource)object).getProject());
            this.init(editingContext);
        } else if (object instanceof IDependentProject) {
            IDependentProject dependentProject = (IDependentProject)object;
            NewWizardEditingContext editingContext = NewWizardEditingContext.create(dependentProject.getParent().getProject());
            this.init(editingContext, dependentProject);
        } else {
            IProject project = null;
            ISelection sel = workbench.getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (sel instanceof IStructuredSelection) {
                Object first = ((IStructuredSelection)sel).getFirstElement();
                if (first instanceof EObject) {
                    project = this.resourceLookup.getProject((EObject)((IStructuredSelection)sel).getFirstElement());
                } else if (first instanceof IndexedTopObjectCollectionNavigatorAdapterBase) {
                    project = ((IndexedTopObjectCollectionNavigatorAdapterBase)first).getProject();
                } else if (first instanceof CommonNavigatorAdapter) {
                    project = (IProject)((CommonNavigatorAdapter)first).getParent(null);
                }
            }
            NewWizardEditingContext editingContext = NewWizardEditingContext.create(project);
            this.init(editingContext);
        }
    }
}

