/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.md.ui.navigator.adapters.CommonNavigatorAdapter;
import com._1c.g5.v8.dt.navigator.adapters.IndexedTopObjectCollectionNavigatorAdapterBase;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.ui.ExecutionErrorDialog;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.lang.model.TranslateLanguageFactory;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ui.projecteditor.AbstractSettingsWizard;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.LanguageLiterals;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.NewWizardEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslateLanguageWizardPage;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class TranslateLanguageWizard
extends AbstractSettingsWizard
implements INewWizard {
    @Inject
    private IResourceLookup resourceLookup;
    private V8TranslateLanguage language;
    private static final EStructuralFeature[] FEATURES = new EStructuralFeature[]{LanguageLiterals.UUID, LanguageLiterals.NAME, LanguageLiterals.COMMENT, LanguageLiterals.CODE, LanguageLiterals.OPTION};
    private boolean isNew;
    private boolean saveContextOnFinish = false;

    public TranslateLanguageWizard() {
        super(FEATURES);
    }

    public void init(ISettingsEditingContext editingContext, V8TranslateLanguage language) {
        this.setEditingContext(editingContext);
        this.isNew = false;
        this.language = language;
        this.updateAttributeMap((EObject)language);
        this.appendLanguageSynonymsToMap();
    }

    public void init(ISettingsEditingContext editingContext) {
        this.setEditingContext(editingContext);
        this.isNew = true;
        this.language = TranslateLanguageFactory.eINSTANCE.createV8TranslateLanguage();
        this.language.setOption(TranslationOption.INTERFACE_ONLY);
        this.language.setUuid(UUID.randomUUID());
        this.language.setName(Messages.TranslateLanguageWizard_Language);
        this.language.getSynonym().put((Object)"", (Object)Messages.TranslateLanguageWizard_Language);
        this.language.setLanguageCode("");
        this.updateAttributeMap((EObject)this.language);
        this.appendLanguageSynonymsToMap();
    }

    public void addPages() {
        TranslateLanguageWizardPage page = new TranslateLanguageWizardPage((IObservableMap<Object, Object>)this.attributesMap);
        this.addPage(page);
    }

    public boolean performFinish() {
        this.updateObject((EObject)this.language);
        for (V8TranslateLanguage lang : this.getEditingContext().getLanguages()) {
            String value = (String)this.attributesMap.get((Object)lang.getLanguageCode());
            if (Strings.isNullOrEmpty((String)value)) {
                this.language.getSynonym().removeKey((Object)lang.getLanguageCode());
                continue;
            }
            this.language.getSynonym().put((Object)lang.getLanguageCode(), (Object)value);
        }
        if (this.isNew) {
            this.getEditingContext().getTranslateLanguageSettings().add(this.language);
        } else {
            this.getEditingContext().getTranslateLanguageSettings().update(this.language);
        }
        if (this.saveContextOnFinish) {
            try {
                this.getContainer().run(true, true, monitor -> {
                    monitor.beginTask(Messages.TranslateLanguageWizard_Saving_Translate_language, -1);
                    this.getEditingContext().doSave(monitor);
                });
            }
            catch (InvocationTargetException e) {
                V8UiPlugin.logError(e);
                ExecutionErrorDialog.openError((Shell)this.getShell(), (String)Messages.TranslateLanguageWizard_Saving_the_Translate_language_was_failed, (Throwable)e);
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public V8TranslateLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(V8TranslateLanguage language) {
        this.language = language;
    }

    private void appendLanguageSynonymsToMap() {
        if (this.getEditingContext().getProject() != null) {
            for (V8TranslateLanguage lang : this.getEditingContext().getLanguages()) {
                String value = (String)this.language.getSynonym().get((Object)lang.getLanguageCode());
                this.attributesMap.put((Object)lang.getLanguageCode(), (Object)value);
            }
        }
    }

    private void removeLanguageSynonymsToMap() {
        if (this.getEditingContext().getProject() != null) {
            for (V8TranslateLanguage lang : this.getEditingContext().getLanguages()) {
                this.attributesMap.remove((Object)lang.getLanguageCode());
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.saveContextOnFinish = true;
        this.setNeedsProgressMonitor(true);
        Object object = selection.getFirstElement();
        if (object instanceof IResource) {
            NewWizardEditingContext editingContext = NewWizardEditingContext.create(((IResource)object).getProject());
            this.init(editingContext);
        } else {
            IProject project = null;
            ISelection sel = workbench.getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (sel instanceof IStructuredSelection) {
                Object first = ((IStructuredSelection)sel).getFirstElement();
                if (first instanceof EObject) {
                    project = this.resourceLookup.getProject((EObject)((IStructuredSelection)sel).getFirstElement());
                } else if (first instanceof IndexedTopObjectCollectionNavigatorAdapterBase) {
                    project = ((IndexedTopObjectCollectionNavigatorAdapterBase)first).getProject();
                } else if (first instanceof CommonNavigatorAdapter) {
                    project = (IProject)((CommonNavigatorAdapter)first).getParent(null);
                }
            }
            NewWizardEditingContext editingContext = NewWizardEditingContext.create(project);
            this.init(editingContext);
        }
    }

    public void setProject(IProject project) {
        if (this.getEditingContext().getProject() != null && !this.getEditingContext().getProject().equals((Object)project)) {
            this.removeLanguageSynonymsToMap();
        }
        if (this.getEditingContext().getProject() == null || !this.getEditingContext().getProject().equals((Object)project)) {
            NewWizardEditingContext editingContext = NewWizardEditingContext.create(project);
            this.setEditingContext(editingContext);
            this.appendLanguageSynonymsToMap();
        }
    }
}

