/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IDependentProject;
import com._1c.g5.v8.dt.core.platform.IExtensionProject;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.md.extension.adopt.IModelObjectAdopter;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.langtool.flags.ui.SharedImages;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.lang.model.TranslateLanguageFactory;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.e1c.langtool.v8.dt.platform.ITranslatingConfigurationProject;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslateLanguagesSection;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class TranslateLanguagesExtensionSection
extends TranslateLanguagesSection {
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private IModelObjectAdopter modelObjectAdopter;
    @Inject
    protected IV8ProjectManager v8ProjectManager;

    protected void convetBaseLanguages(List<TranslateLanguage> languages) {
        this.addLanguagesToExtension(languages);
        this.convertLanguages(languages);
    }

    private void addLanguagesToExtension(List<TranslateLanguage> languages) {
        Set addToExtension = languages.stream().map(TranslateLanguage::getName).collect(Collectors.toSet());
        Configuration extension = this.configurationProvider.getConfiguration(this.editor.getProject());
        for (Language language : extension.getLanguages()) {
            addToExtension.remove(language.getName());
        }
        if (!addToExtension.isEmpty()) {
            IV8Project v8Project = this.v8ProjectManager.getProject(this.editor.getProject());
            if (!(v8Project instanceof IExtensionProject)) {
                return;
            }
            IExtensionProject extProject = (IExtensionProject)v8Project;
            IProject sourceProject = extProject.getParentProject();
            ITranslatingProject translating = this.translatingProjectManager.getProject(sourceProject);
            if (!translating.isTranslating() || !(translating instanceof ITranslatingConfigurationProject)) {
                return;
            }
            Configuration configuration = this.configurationProvider.getConfiguration(sourceProject);
            for (Language language : configuration.getLanguages()) {
                if (!addToExtension.contains(language.getName())) continue;
                try {
                    this.modelObjectAdopter.adoptAndAttach((EObject)language, extProject, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    V8UiPlugin.logError(e);
                }
            }
        }
    }

    protected void convertLanguages(List<TranslateLanguage> languages) {
        Map<String, TranslateLanguage> langNames = languages.stream().collect(Collectors.toMap(l -> l.getName(), l -> l));
        IV8Project v8project = this.v8ProjectManager.getProject(this.editor.getProject());
        for (Language language : v8project.getLanguages()) {
            TranslateLanguage source = langNames.get(language.getName());
            if (source == null) continue;
            V8TranslateLanguage newLang = TranslateLanguageFactory.eINSTANCE.createV8TranslateLanguage();
            LanguageUtil.copyLanguageContent((Language)language, (V8TranslateLanguage)newLang);
            langNames.remove(language.getName());
            newLang.setOption(source.getOption());
            this.context.getTranslateLanguageSettings().add(newLang);
        }
    }

    @Override
    protected void addLanguageToTranslation() {
        this.selectLanguageToTranslation();
    }

    protected void selectLanguageToTranslation() {
        IV8Project v8Project = this.v8ProjectManager.getProject(this.editor.getProject());
        if (!(v8Project instanceof IDependentProject)) {
            return;
        }
        IDependentProject dependent = (IDependentProject)v8Project;
        final IProject sourceProject = dependent.getParentProject();
        ITranslatingProject translating = this.translatingProjectManager.getProject(sourceProject);
        if (!translating.isTranslating()) {
            return;
        }
        LabelProvider renderer = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TranslateLanguage) {
                    return ((TranslateLanguage)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof TranslateLanguage) {
                    return SharedImages.getLanguageFlagImage((IProject)sourceProject, (String)((TranslateLanguage)element).getLanguageCode());
                }
                return null;
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.editor.getSite().getShell(), (ILabelProvider)renderer);
        dialog.setTitle(Messages.TranslateLanguagesExtensionSection_Select_translate_language);
        dialog.setMessage(Messages.TranslateLanguagesExtensionSection_Select_translate_language_from_base_Configuration_project);
        dialog.setMultipleSelection(true);
        dialog.setElements(translating.getInterfaceLanguages().toArray());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            List<Object> languages = new ArrayList<TranslateLanguage>();
            int i = 0;
            while (i < result.length) {
                Object item = result[i];
                if (item instanceof TranslateLanguage) {
                    languages.add((TranslateLanguage)item);
                }
                ++i;
            }
            Set skip = this.context.getTranslateLanguageSettings().getAllLanguages().stream().map(l -> l.getName()).collect(Collectors.toSet());
            if (!(languages = languages.stream().filter(l -> !skip.contains(l.getName())).collect(Collectors.toList())).isEmpty()) {
                this.convetBaseLanguages(languages);
                this.loadViewerInput();
            }
        }
    }
}

