/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.common.Functions;
import com._1c.g5.v8.dt.ui.V8UiSharedImages;
import com._1c.g5.v8.dt.ui.editor.IProjectEditor;
import com._1c.g5.v8.dt.ui.editor.IProjectEditorSection;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContextProvider;
import com.e1c.langtool.v8.dt.ui.projecteditor.LanguageLiterals;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslateLanguageWizard;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TranslateLanguagesSection
implements IProjectEditorSection {
    protected static final EStructuralFeature[] FEATURES = new EStructuralFeature[]{LanguageLiterals.NAME, LanguageLiterals.CODE, LanguageLiterals.OPTION, LanguageLiterals.SYNONYM, LanguageLiterals.COMMENT};
    protected static final String COLUMN_DATA_FEATURE = "feature";
    @Inject
    @Named(value="com.e1c.langtool.v8.dt.ui.ProjectEditorContextProvider")
    protected ISettingsEditingContextProvider contextProvider;
    protected IProjectEditor editor;
    protected ISettingsEditingContext context;
    protected TableViewer languagesViewer;

    public void dispose() {
        if (this.context != null && !this.context.isDisposed()) {
            this.context.dispose();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.getContext().doSave(monitor);
    }

    public void inputChanged(IProjectEditor projectEditor) {
        this.editor = projectEditor;
        this.setContext(this.contextProvider.getContext(this.editor));
        this.loadViewerInput();
        this.context.setDirty(false);
    }

    protected void loadViewerInput() {
        List objects = this.context.getTranslateLanguageSettings().getAllLanguages().stream().map(proj -> proj).collect(Collectors.toList());
        IObservableList input = Properties.selfList(V8TranslateLanguage.class).observe(objects);
        this.languagesViewer.setInput((Object)input);
    }

    public boolean isDirty() {
        return this.getContext().isDirty();
    }

    public void createContent(IProjectEditor projectEditor, IFormPage formPage, FormToolkit toolkit, Composite parent, Section section) {
        this.editor = projectEditor;
        GridDataFactory.fillDefaults().grab(true, false).hint(300, 190).applyTo((Control)section);
        Composite topLevel = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().applyTo(topLevel);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 150).applyTo((Control)topLevel);
        this.languagesViewer = new TableViewer(topLevel, 68354);
        this.createViewerColumns(this.languagesViewer, FEATURES);
        Table table = this.languagesViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 150).applyTo((Control)table);
        ObservableListContentProvider languagesContentProvider = new ObservableListContentProvider();
        this.languagesViewer.setContentProvider((IContentProvider)languagesContentProvider);
        ObservableMapLabelProvider labelProvider = new ObservableMapLabelProvider(Properties.observeEach((IObservableSet)languagesContentProvider.getKnownElements(), (IValueProperty[])EMFProperties.values((EStructuralFeature[])FEATURES))){

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex < FEATURES.length && element instanceof EObject) {
                    EStructuralFeature feature = FEATURES[columnIndex];
                    Object value = ((EObject)element).eGet(feature);
                    if (value instanceof String) {
                        return (String)value;
                    }
                    if (feature.equals(LanguageLiterals.OPTION)) {
                        if (TranslationOption.MODEL_AND_INTERFACE == value) {
                            return Messages.TranslationOptionLableProvider_Model_and_Interface;
                        }
                        if (TranslationOption.INTERFACE_ONLY == value) {
                            return Messages.TranslationOptionLableProvider_Interface_only;
                        }
                        return null;
                    }
                    if (feature.equals(LanguageLiterals.SYNONYM)) {
                        Object stringValue = ((EMap)value).get(((EObject)element).eGet(LanguageLiterals.CODE));
                        return stringValue instanceof String ? (String)stringValue : "";
                    }
                    return value == null ? "" : value.toString();
                }
                return null;
            }
        };
        this.languagesViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.editor.getSite().setSelectionProvider((ISelectionProvider)this.languagesViewer);
        this.\u0441reateToolBar(projectEditor, section);
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public ISettingsEditingContext getContext() {
        return this.context;
    }

    public void setContext(ISettingsEditingContext context) {
        this.context = context;
    }

    protected void \u0441reateToolBar(IProjectEditor editor, Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        toolbar.setCursor(Display.getDefault().getSystemCursor(21));
        this.addToToolBarAddLanguageAction(editor, toolBarManager);
        this.addToToolBarEditLanguageAction(editor, toolBarManager);
        this.addToToolBarRemoveLanguageAction(editor, toolBarManager);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    protected void addToToolBarEditLanguageAction(IProjectEditor editor, ToolBarManager toolBarManager) {
        EditLanguage editLanguageAction = new EditLanguage((ISelectionProvider)this.languagesViewer);
        toolBarManager.add((IAction)editLanguageAction);
        IActionBars actionBars = ((IEditorSite)editor.getSite()).getActionBars();
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.openEditor", (IAction)editLanguageAction);
        this.languagesViewer.addDoubleClickListener(arg_0 -> this.lambda$1((IAction)editLanguageAction, arg_0));
    }

    protected void addToToolBarRemoveLanguageAction(IProjectEditor editor, ToolBarManager toolBarManager) {
        RemoveLanguageFromTranslation delete = new RemoveLanguageFromTranslation((ISelectionProvider)this.languagesViewer);
        toolBarManager.add((IAction)delete);
        IActionBars actionBars = ((IEditorSite)editor.getSite()).getActionBars();
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.delete", (IAction)delete);
    }

    protected void addToToolBarAddLanguageAction(IProjectEditor editor, ToolBarManager toolBarManager) {
        AddLanguageToTranslation add = new AddLanguageToTranslation((ISelectionProvider)this.languagesViewer);
        toolBarManager.add((IAction)add);
        IActionBars actionBars = ((IEditorSite)editor.getSite()).getActionBars();
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.create", (IAction)add);
    }

    private void createViewerColumns(TableViewer viewer, EStructuralFeature[] features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            String title = (String)Functions.featureToLabel().apply((Object)feature);
            TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
            TableColumn column = viewerColumn.getColumn();
            column.setText(title);
            column.setWidth(100);
            column.setResizable(true);
            column.setMoveable(true);
            column.setData(COLUMN_DATA_FEATURE, (Object)feature);
            ++n2;
        }
    }

    protected void addLanguageToTranslation() {
        TranslateLanguageWizard wizard = new TranslateLanguageWizard();
        wizard.init(this.getContext());
        WizardDialog dialog = new WizardDialog(this.editor.getSite().getShell(), (IWizard)wizard);
        dialog.open();
        this.loadViewerInput();
    }

    private /* synthetic */ void lambda$1(IAction iAction, DoubleClickEvent event) {
        if (this.languagesViewer == event.getViewer() && !event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
            iAction.run();
        }
    }

    protected class AddLanguageToTranslation
    extends SelectionProviderAction {
        protected AddLanguageToTranslation(ISelectionProvider provider) {
            super(provider, Messages.TranslateLanguagesSection_Add_language);
            this.setImageDescriptor(TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/elcl16/add_translate_language.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.create");
        }

        public void run() {
            TranslateLanguagesSection.this.addLanguageToTranslation();
        }
    }

    protected class EditLanguage
    extends SelectionProviderAction {
        protected EditLanguage(ISelectionProvider provider) {
            super(provider, Messages.TranslateLanguagesSection_Edit_language);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/edit_element.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.openEditor");
            this.setEnabled(false);
        }

        public void run() {
            if (this.getStructuredSelection().isEmpty()) {
                return;
            }
            TranslateLanguageWizard wizard = new TranslateLanguageWizard();
            V8TranslateLanguage language = (V8TranslateLanguage)this.getStructuredSelection().getFirstElement();
            wizard.init(TranslateLanguagesSection.this.getContext(), language);
            WizardDialog dialog = new WizardDialog(TranslateLanguagesSection.this.editor.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            TranslateLanguagesSection.this.loadViewerInput();
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (selection.isEmpty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    protected class RemoveLanguageFromTranslation
    extends SelectionProviderAction {
        protected RemoveLanguageFromTranslation(ISelectionProvider provider) {
            super(provider, Messages.TranslateLanguagesSection_Remove_language);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/delete_element.png"));
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
            this.setEnabled(false);
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection != null && !selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof V8TranslateLanguage)) continue;
                    TranslateLanguagesSection.this.getContext().getTranslateLanguageSettings().remove((V8TranslateLanguage)element);
                    TranslateLanguagesSection.this.getContext().markDirty();
                }
            }
            TranslateLanguagesSection.this.loadViewerInput();
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (selection.isEmpty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

