/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.ui.projecteditor.LangObserver;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TranslateStringDialog
extends TitleAreaDialog {
    protected static final String LANG_KEY = "lang";
    private static final String WINDOW_NAME = Messages.TranslateStringDialog_Window_name;
    private DataBindingContext dbc = new EMFDataBindingContext();
    private final IObservableMap<String, String> observableMap = new WritableMap(String.class, String.class);
    private final boolean multiLine;
    private LangObserver langObserver;
    private Integer editorHeightHint;

    public TranslateStringDialog(Shell parentShell, LangObserver langObserver, boolean multiLine, Map<String, String> inputData) {
        super(parentShell);
        this.setShellStyle(65536);
        this.multiLine = multiLine;
        this.langObserver = langObserver;
        this.getValues().putAll(inputData);
    }

    public Map<String, String> getValues() {
        return this.observableMap;
    }

    public boolean close() {
        this.dbc.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite bg = new Composite(parent, 0);
        this.setTitle(WINDOW_NAME);
        GridLayoutFactory.swtDefaults().applyTo(bg);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)bg);
        this.createTextEditingArea(bg);
        return bg;
    }

    protected void createTextEditingArea(Composite parent) {
        Map<String, String> languages = this.getLanguagesMap();
        String activeLanguageCode = this.langObserver.getCurrentLanguageCode();
        for (Map.Entry<String, String> lang : languages.entrySet()) {
            Label langLabel = new Label(parent, 0);
            langLabel.setText(lang.getValue() == null ? lang.getKey() : lang.getValue());
            String languageCode = lang.getKey();
            boolean makeActive = Objects.equals(activeLanguageCode, languageCode);
            Control textEditor = this.createTextEditor(parent, this.getEditorContent(languageCode), languageCode, makeActive);
            textEditor.setData(LANG_KEY, (Object)languageCode);
            this.setTextEditorLayoutData(textEditor);
        }
    }

    protected Control createTextEditor(Composite parent, String content, String languageCode, boolean makeActive) {
        int style = 2048;
        if (this.isMultiline()) {
            style |= 0x200;
        }
        Text editor = new Text(parent, style);
        editor.setText(content);
        if (makeActive) {
            editor.setSelection(0, editor.getText().length());
            editor.setFocus();
        }
        this.bindTextEditor((Control)editor, languageCode);
        return editor;
    }

    protected UpdateValueStrategy<String, String> createTargetToModel(String lang) {
        UpdateValueStrategy result = new UpdateValueStrategy();
        result.setBeforeSetValidator(this.getValidator(lang));
        return result;
    }

    protected IValidator<String> getValidator(String lang) {
        return null;
    }

    protected Map<String, String> getLanguagesMap() {
        LinkedHashMap languages = Maps.newLinkedHashMap();
        for (V8TranslateLanguage lang : this.langObserver.getLanguages()) {
            String langSynonym = (String)lang.getSynonym().get((Object)lang.getSynonym());
            if (langSynonym == null) {
                langSynonym = lang.getName();
            }
            languages.put(lang.getLanguageCode(), langSynonym);
        }
        for (Map.Entry<String, String> entry : this.getValues().entrySet()) {
            if (languages.containsKey(entry.getKey())) continue;
            languages.put(entry.getKey(), entry.getValue());
        }
        return languages;
    }

    protected LangObserver getLangObserver() {
        return this.langObserver;
    }

    protected DataBindingContext getBindingContext() {
        return this.dbc;
    }

    protected IObservableMap<String, String> getObservableMap() {
        return this.observableMap;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(WINDOW_NAME);
    }

    protected boolean isMultiline() {
        return this.multiLine;
    }

    private void bindTextEditor(Control textEditor, String languageCode) {
        Binding binding = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observeDelayed(400, (Widget)textEditor), Observables.observeMapEntry(this.observableMap, (Object)languageCode), this.createTargetToModel(languageCode), UpdateValueStrategy.never());
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512, null);
    }

    private String getEditorContent(String languageCode) {
        Object value = this.observableMap.get((Object)languageCode);
        return value == null ? "" : String.valueOf(value);
    }

    private void setTextEditorLayoutData(Control textEditor) {
        int vHint = this.isMultiline() ? this.getEditorHeightHint(textEditor) : -1;
        int vAlign = this.isMultiline() ? 4 : 0x1000000;
        GridDataFactory.fillDefaults().grab(true, true).align(4, vAlign).hint(-1, vHint).applyTo(textEditor);
    }

    private int getEditorHeightHint(Control editor) {
        if (this.editorHeightHint == null) {
            GC gc = new GC((Drawable)editor);
            this.editorHeightHint = 5 * gc.getFontMetrics().getHeight();
            gc.dispose();
        }
        return this.editorHeightHint;
    }
}

