/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.common.Functions;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.ui.V8UiSharedImages;
import com._1c.g5.v8.dt.ui.editor.IProjectEditor;
import com._1c.g5.v8.dt.ui.editor.IProjectEditorSection;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatedProjectManager;
import com.e1c.langtool.sync.EqualityState;
import com.e1c.langtool.sync.StateChangeListener;
import com.e1c.langtool.sync.SyncStrategy;
import com.e1c.langtool.sync.SynchronizationService;
import com.e1c.langtool.sync.change.ChangeManager;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.v8.dt.internal.ui.V8UiPlugin;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProject;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProjectPackage;
import com.e1c.langtool.v8.dt.ui.projecteditor.ILanguageChangedListener;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContextProvider;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslatedProjectWizard;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TranslatedProjectSection
implements IProjectEditorSection {
    private static final EStructuralFeature[] PROJECT_FEATURES = new EStructuralFeature[]{V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__NAME, V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__DEFAULT_LANGUAGE_NAME, V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__INTERFACE_LANGUAGE_NAMES, V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__SCRIPT_VARIANT};
    private static final Map<ScriptVariant, String> SCRIPT_VARIANT_VARIABLES = Map.of(ScriptVariant.ENGLISH, (String)Functions.literalToLabel().apply((Object)MdClassPackage.Literals.SCRIPT_VARIANT.getEEnumLiteral(0)), ScriptVariant.RUSSIAN, (String)Functions.literalToLabel().apply((Object)MdClassPackage.Literals.SCRIPT_VARIANT.getEEnumLiteral(1)));
    private static final String COLUMN_DATA_FEATURE = "feature";
    @Inject
    @Named(value="com.e1c.langtool.v8.dt.ui.ProjectEditorContextProvider")
    private ISettingsEditingContextProvider contextProvider;
    @Inject
    private ITranslatedProjectManager translatedProjectManager;
    @Inject
    private SynchronizationService syncService;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    private IProjectEditor editor;
    private ISettingsEditingContext context;
    private TableViewer projectsViewer;
    private IAction editProjectAction;
    private ILanguageChangedListener languageChangeListener;
    private StateChangeListener syncStateListener;
    private StateChangeListener selectedItemStateListener;

    public void createContent(IProjectEditor projectEditor, IFormPage formPage, FormToolkit toolkit, Composite parent, Section section) {
        this.editor = projectEditor;
        GridDataFactory.fillDefaults().grab(true, false).hint(300, 480).applyTo((Control)section);
        Composite topLevel = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().applyTo(topLevel);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 450).applyTo((Control)topLevel);
        this.projectsViewer = new TableViewer(topLevel, 68354);
        this.createViewerColumns(this.projectsViewer, PROJECT_FEATURES);
        this.createViewerColumnSyncMode(this.projectsViewer);
        this.createViewerColumnSyncStatus(this.projectsViewer);
        Table projectTable = this.projectsViewer.getTable();
        projectTable.setHeaderVisible(true);
        projectTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).applyTo((Control)projectTable);
        ObservableListContentProvider projectContentProvider = new ObservableListContentProvider();
        this.projectsViewer.setContentProvider((IContentProvider)projectContentProvider);
        IObservableMap[] observableMaps = Properties.observeEach((IObservableSet)projectContentProvider.getKnownElements(), (IValueProperty[])EMFProperties.values((EStructuralFeature[])PROJECT_FEATURES));
        this.projectsViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observableMaps){

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex < PROJECT_FEATURES.length && element instanceof EObject) {
                    EStructuralFeature feature = PROJECT_FEATURES[columnIndex];
                    Object value = ((EObject)element).eGet(feature);
                    if (value instanceof String) {
                        return (String)value;
                    }
                    if (feature.equals(V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__SCRIPT_VARIANT)) {
                        if (!((EObject)element).eIsSet(feature)) {
                            value = TranslatedProjectSection.this.editor.getV8Project().getScriptVariant();
                        }
                        return SCRIPT_VARIANT_VARIABLES.get(value);
                    }
                    if (feature.equals(V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__DEFAULT_LANGUAGE_NAME)) {
                        if (value == null) {
                            Language language = TranslatedProjectSection.this.editor.getV8Project().getDefaultLanguage();
                            String lable = (String)language.getSynonym().get((Object)language.getLanguageCode());
                            return lable == null ? language.getName() : lable;
                        }
                        if (value instanceof String) {
                            return (String)value;
                        }
                    } else if (feature.equals(V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__INTERFACE_LANGUAGE_NAMES)) {
                        EList languages = (EList)value;
                        return languages.stream().collect(Collectors.joining(", "));
                    }
                } else if (columnIndex == PROJECT_FEATURES.length + 1 && element instanceof V8TranslatedProject) {
                    String name = ((V8TranslatedProject)element).getName();
                    if (!TranslatedProjectSection.this.isDirty() && StringUtils.isNotEmpty((String)name) && Path.isValidPosixPath((String)name)) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        EqualityState state = TranslatedProjectSection.this.syncService.getSynchronizationManager(project).getEqualityState();
                        return TranslatedProjectSection.this.getEqualityStateText(state, project);
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == PROJECT_FEATURES.length && element instanceof V8TranslatedProject) {
                    String name = ((V8TranslatedProject)element).getName();
                    if (!TranslatedProjectSection.this.isDirty() && StringUtils.isNotEmpty((String)name) && Path.isValidPosixPath((String)name)) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        SyncStrategy strategy = TranslatedProjectSection.this.syncService.getSynchronizationManager(project).getSyncStrategy();
                        if (SyncStrategy.AUTO.equals((Object)strategy)) {
                            return V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/auto_sync.png");
                        }
                        return V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/manual_sync.png");
                    }
                } else if (columnIndex == PROJECT_FEATURES.length + 1 && element instanceof V8TranslatedProject) {
                    String name = ((V8TranslatedProject)element).getName();
                    if (!TranslatedProjectSection.this.isDirty() && StringUtils.isNotEmpty((String)name) && Path.isValidPosixPath((String)name)) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        EqualityState state = TranslatedProjectSection.this.syncService.getSynchronizationManager(project).getEqualityState();
                        return TranslatedProjectSection.this.getEqualityStateImage(state);
                    }
                }
                return null;
            }
        });
        this.projectsViewer.addDoubleClickListener(event -> {
            if (this.projectsViewer == event.getViewer() && !event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                this.editProjectAction.run();
            }
        });
        this.createSyncStatusGroup(toolkit, topLevel, this.projectsViewer);
        this.createSyncModeGroup(toolkit, topLevel, this.projectsViewer);
        this.editor.getSite().setSelectionProvider((ISelectionProvider)this.projectsViewer);
        this.createToolBar(projectEditor, section);
        this.context = this.contextProvider.getContext(this.editor);
        this.languageChangeListener = event -> {
            if (event.getAction() == ILanguageChangedListener.Action.DELETED) {
                this.performLanguageDeleteAction(event.getLanguage());
            }
            this.inputChanged(this.editor);
        };
        this.context.addLanguageChangedListener(this.languageChangeListener);
        this.syncStateListener = event -> {
            String name = event.getProject().getName();
            Optional<V8TranslatedProject> project = this.context.getTranslatedProjectSettings().getAllProjects().stream().filter(p -> name.equals(p.getName())).findAny();
            if (project.isPresent() && !this.projectsViewer.getControl().getDisplay().isDisposed()) {
                this.projectsViewer.getControl().getDisplay().asyncExec(() -> this.projectsViewer.refresh(project.get()));
            }
        };
        this.syncService.addStateChangeListener(this.syncStateListener);
    }

    private void performLanguageDeleteAction(V8TranslateLanguage language) {
        ArrayList projectsToDelete = new ArrayList();
        this.context.getTranslatedProjectSettings().getAllProjects().forEach(project -> {
            boolean isContainEventLanguage;
            if (project.getDefaultLanguageName() != null && project.getDefaultLanguageName().equals(language.getName())) {
                projectsToDelete.add(project);
            }
            if (isContainEventLanguage = project.getInterfaceLanguageNames().stream().anyMatch(lang -> lang.equals(language.getName()))) {
                if (project.getInterfaceLanguageNames().size() == 1) {
                    projectsToDelete.add(project);
                } else {
                    project.getInterfaceLanguageNames().remove((Object)language.getName());
                }
            }
        });
        projectsToDelete.forEach(project -> this.context.getTranslatedProjectSettings().remove((V8TranslatedProject)project));
    }

    public void dispose() {
        if (this.context != null && !this.context.isDisposed()) {
            this.context.dispose();
            this.context.removeLanguageChangedListener(this.languageChangeListener);
        }
        if (this.syncStateListener != null) {
            this.syncService.removeStateChangeListener(this.syncStateListener);
        }
        if (this.selectedItemStateListener != null) {
            this.syncService.removeStateChangeListener(this.selectedItemStateListener);
        }
    }

    public void doSave(IProgressMonitor monitor) throws CoreException {
        this.context.doSave(monitor);
    }

    public void inputChanged(IProjectEditor projectEditor) {
        this.editor = projectEditor;
        this.context = this.contextProvider.getContext(this.editor);
        this.loadViewerInput();
        this.context.setDirty(false);
    }

    private void loadViewerInput() {
        List objects = this.context.getTranslatedProjectSettings().getAllProjects().stream().map(proj -> proj).collect(Collectors.toList());
        IObservableList input = Properties.selfList(V8TranslatedProject.class).observe(objects);
        this.projectsViewer.setInput((Object)input);
    }

    public boolean isDirty() {
        return this.context.isDirty();
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    private void createViewerColumns(TableViewer viewer, EStructuralFeature[] features) {
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            String title = (String)Functions.featureToLabel().apply((Object)feature);
            TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
            TableColumn column = viewerColumn.getColumn();
            column.setText(title);
            column.setWidth(100);
            column.setResizable(true);
            column.setMoveable(true);
            column.setData(COLUMN_DATA_FEATURE, (Object)feature);
            ++n2;
        }
    }

    private void createViewerColumnSyncMode(TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setImage(V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/sync_mode.png"));
        column.setAlignment(0x1000000);
        column.setWidth(30);
        column.setResizable(false);
        column.setMoveable(true);
    }

    private void createViewerColumnSyncStatus(TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(Messages.TranslatedProjectSection_StatusColumnTitle);
        column.setWidth(200);
        column.setResizable(true);
        column.setMoveable(true);
    }

    private void createToolBar(IProjectEditor editor, Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        toolbar.setCursor(Display.getDefault().getSystemCursor(21));
        AddProject add = new AddProject((ISelectionProvider)this.projectsViewer);
        toolBarManager.add((IAction)add);
        SynchronizeProject sync = new SynchronizeProject((ISelectionProvider)this.projectsViewer);
        toolBarManager.add((IAction)sync);
        this.editProjectAction = new EditProject((ISelectionProvider)this.projectsViewer);
        toolBarManager.add(this.editProjectAction);
        DeleteProject delete = new DeleteProject((ISelectionProvider)this.projectsViewer);
        toolBarManager.add((IAction)delete);
        IActionBars actionBars = ((IEditorSite)editor.getSite()).getActionBars();
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.delete", (IAction)delete);
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.create", (IAction)add);
        actionBars.setGlobalActionHandler("com._1c.g5.v8.dt.ui.commands.openEditor", this.editProjectAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    protected TranslatedProjectWizard createTranslatedPrrojectWizard() {
        return new TranslatedProjectWizard(this.resourceLookup);
    }

    private void createSyncStatusGroup(FormToolkit toolkit, Composite parent, TableViewer viewer) {
        Composite top = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(top);
        GridDataFactory.fillDefaults().grab(true, false).hint(150, -1).applyTo((Control)top);
        toolkit.createLabel(top, Messages.TranslatedProjectSection_Project_status);
        Label statusImage = toolkit.createLabel(top, null);
        statusImage.setImage(this.getEqualityStateImage(EqualityState.NOT_CREATED));
        Label statusLabel = toolkit.createLabel(top, Messages.TranslatedProjectSection_Select_project_text);
        statusLabel.setEnabled(false);
        this.selectedItemStateListener = event -> {
            IProject project = event.getProject();
            if (statusLabel.isDisposed() || statusLabel.getDisplay().isDisposed()) {
                return;
            }
            statusLabel.getDisplay().asyncExec(() -> {
                if (!viewer.getStructuredSelection().isEmpty() && viewer.getStructuredSelection().getFirstElement() instanceof V8TranslatedProject) {
                    V8TranslatedProject v8Project = (V8TranslatedProject)viewer.getStructuredSelection().getFirstElement();
                    String name = v8Project.getName();
                    if (!this.isDirty() && StringUtils.isNotEmpty((String)name) && name.equals(project.getName())) {
                        EqualityState state = this.syncService.getSynchronizationManager(project).getEqualityState();
                        statusImage.setImage(this.getEqualityStateImage(state));
                        statusLabel.setText(this.getEqualityStateExtendedText(state, project));
                    }
                } else {
                    statusLabel.setText(Messages.TranslatedProjectSection_Select_project_text);
                }
            });
        };
        viewer.addPostSelectionChangedListener(event -> {
            statusLabel.setEnabled(false);
            this.syncService.removeStateChangeListener(this.selectedItemStateListener);
            if (!event.getStructuredSelection().isEmpty() && event.getStructuredSelection().getFirstElement() instanceof V8TranslatedProject) {
                V8TranslatedProject v8Project = (V8TranslatedProject)event.getStructuredSelection().getFirstElement();
                String name = v8Project.getName();
                if (!this.isDirty() && StringUtils.isNotEmpty((String)name)) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                    EqualityState state = this.syncService.getSynchronizationManager(project).getEqualityState();
                    statusImage.setImage(this.getEqualityStateImage(state));
                    statusLabel.setText(this.getEqualityStateExtendedText(state, project));
                    statusLabel.setEnabled(true);
                    this.syncService.addStateChangeListener(this.selectedItemStateListener);
                }
            }
        });
    }

    private void createSyncModeGroup(FormToolkit toolkit, Composite parent, final TableViewer viewer) {
        Group group = new Group(parent, 4);
        group.setText(Messages.TranslatedProjectSection_Project_sychronzation_mode);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)group);
        final Button autoButton = toolkit.createButton((Composite)group, Messages.TranslatedProjectSection_Automatically_on_changes, 16);
        autoButton.setToolTipText(Messages.TranslatedProjectSection_Automatically_on_changes_tooltip);
        autoButton.setImage(V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/auto_sync.png"));
        toolkit.createLabel((Composite)group, Messages.TranslatedProjectSection_Automatically_on_changes_tooltip);
        Button ondemandButton = toolkit.createButton((Composite)group, Messages.TranslatedProjectSection_Manually_on_demand, 16);
        ondemandButton.setToolTipText(Messages.TranslatedProjectSection_Manually_on_demand_tooltip);
        ondemandButton.setImage(V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/manual_sync.png"));
        toolkit.createLabel((Composite)group, Messages.TranslatedProjectSection_Manually_on_demand_tooltip);
        group.setEnabled(false);
        autoButton.setEnabled(false);
        ondemandButton.setEnabled(false);
        autoButton.setSelection(false);
        ondemandButton.setSelection(true);
        viewer.addPostSelectionChangedListener(event -> {
            group.setEnabled(false);
            autoButton.setEnabled(false);
            ondemandButton.setEnabled(false);
            if (!event.getStructuredSelection().isEmpty() && event.getStructuredSelection().getFirstElement() instanceof V8TranslatedProject) {
                V8TranslatedProject v8Project = (V8TranslatedProject)event.getStructuredSelection().getFirstElement();
                String name = v8Project.getName();
                if (!this.isDirty() && StringUtils.isNotEmpty((String)name)) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                    SyncStrategy strategy = this.syncService.getSynchronizationManager(project).getSyncStrategy();
                    group.setEnabled(true);
                    autoButton.setEnabled(true);
                    ondemandButton.setEnabled(true);
                    autoButton.setSelection(strategy.equals((Object)SyncStrategy.AUTO));
                    ondemandButton.setSelection(strategy.equals((Object)SyncStrategy.ON_DEMAND));
                }
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncStrategy strategy;
                SyncStrategy syncStrategy = strategy = autoButton.getSelection() ? SyncStrategy.AUTO : SyncStrategy.ON_DEMAND;
                if (!viewer.getStructuredSelection().isEmpty() && viewer.getStructuredSelection().getFirstElement() instanceof V8TranslatedProject) {
                    V8TranslatedProject v8Project = (V8TranslatedProject)viewer.getStructuredSelection().getFirstElement();
                    String name = v8Project.getName();
                    if (!TranslatedProjectSection.this.isDirty() && StringUtils.isNotEmpty((String)name)) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        TranslatedProjectSection.this.syncService.getSynchronizationManager(project).setSyncStrategy(strategy);
                        viewer.refresh((Object)v8Project);
                    }
                }
            }
        };
        autoButton.addSelectionListener((SelectionListener)listener);
        ondemandButton.addSelectionListener((SelectionListener)listener);
    }

    private Image getEqualityStateImage(EqualityState state) {
        switch (state) {
            case NEED_UPDATE: {
                return V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/equality_need_update.png");
            }
            case SYNCHRONIZED: {
                return V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/equality_synchronized.png");
            }
            case SYNCHRONIZING: {
                return V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/equality_synchronizing.png");
            }
        }
        return V8UiPlugin.getImage("com.e1c.langtool.v8.dt.ui/obj16/equality_not_created.png");
    }

    private String getEqualityStateExtendedText(EqualityState state, IProject project) {
        String message = "";
        switch (state) {
            case NEED_UPDATE: {
                ITranslatedProject translatedProject = this.translatedProjectManager.getProject(project);
                ChangeManager manager = this.syncService.getChangeManager(translatedProject);
                if (manager.isInitialized()) {
                    int total = manager.getFilesToUpdate().size() + manager.getFilesToRemove().size();
                    message = MessageFormat.format(Messages.TranslatedProjectSection_ExtendedStatus_need_update, project.getName(), total);
                    break;
                }
                message = MessageFormat.format(Messages.TranslatedProjectSection_ExtendedStatus_need_full_update, project.getName());
                break;
            }
            case SYNCHRONIZED: {
                message = MessageFormat.format(Messages.TranslatedProjectSection_ExtendedStatus_synchronized, project.getName());
                break;
            }
            case SYNCHRONIZING: {
                message = MessageFormat.format(Messages.TranslatedProjectSection_ExtendedStatus_synchronizing, project.getName());
                break;
            }
            case NOT_CREATED: {
                message = MessageFormat.format(Messages.TranslatedProjectSection_ExtendedStatus_not_created, project.getName());
                break;
            }
        }
        return message;
    }

    private String getEqualityStateText(EqualityState state, IProject project) {
        switch (state) {
            case NEED_UPDATE: {
                ITranslatedProject translatedProject = this.translatedProjectManager.getProject(project);
                ChangeManager manager = this.syncService.getChangeManager(translatedProject);
                if (manager.isInitialized()) {
                    int total = manager.getFilesToUpdate().size() + manager.getFilesToRemove().size();
                    return MessageFormat.format(Messages.TranslatedProjectSection_Status_need_update, total);
                }
                return Messages.TranslatedProjectSection_Status_need_full_update;
            }
            case SYNCHRONIZED: {
                return Messages.TranslatedProjectSection_Status_synchronized;
            }
            case SYNCHRONIZING: {
                return Messages.TranslatedProjectSection_Status_synchronizing;
            }
            case NOT_CREATED: {
                return Messages.TranslatedProjectSection_Status_not_created;
            }
        }
        return "";
    }

    private class AddProject
    extends SelectionProviderAction {
        protected AddProject(ISelectionProvider provider) {
            super(provider, Messages.TranslatedProjectSection_Add_Translated_Project);
            this.setImageDescriptor(TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/elcl16/add_translated_project.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.create");
        }

        public void run() {
            TranslatedProjectWizard wizard = TranslatedProjectSection.this.createTranslatedPrrojectWizard();
            wizard.init(TranslatedProjectSection.this.context);
            WizardDialog dialog = new WizardDialog(TranslatedProjectSection.this.editor.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            TranslatedProjectSection.this.loadViewerInput();
        }
    }

    private class DeleteProject
    extends SelectionProviderAction {
        protected DeleteProject(ISelectionProvider provider) {
            super(provider, Messages.TranslatedProjectSection_Delete_Translated_Project);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/delete_element.png"));
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
            this.setEnabled(false);
        }

        public void run() {
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection != null && !selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof V8TranslatedProject)) continue;
                    TranslatedProjectSection.this.context.getTranslatedProjectSettings().remove((V8TranslatedProject)element);
                    TranslatedProjectSection.this.context.markDirty();
                }
            }
            TranslatedProjectSection.this.loadViewerInput();
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.setEnabled(!selection.isEmpty());
        }
    }

    private class EditProject
    extends SelectionProviderAction {
        protected EditProject(ISelectionProvider provider) {
            super(provider, Messages.TranslatedProjectSection_Edit_Translated_Project);
            this.setImageDescriptor(V8UiSharedImages.getImageDescriptor((String)"/icons/obj16/edit_element.png"));
            this.setActionDefinitionId("com._1c.g5.v8.dt.ui.commands.openEditor");
            this.setEnabled(false);
        }

        public void run() {
            if (this.getStructuredSelection().isEmpty()) {
                return;
            }
            TranslatedProjectWizard wizard = TranslatedProjectSection.this.createTranslatedPrrojectWizard();
            wizard.init(TranslatedProjectSection.this.context, (V8TranslatedProject)this.getStructuredSelection().getFirstElement());
            WizardDialog dialog = new WizardDialog(TranslatedProjectSection.this.editor.getSite().getShell(), (IWizard)wizard);
            dialog.open();
            TranslatedProjectSection.this.loadViewerInput();
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.setEnabled(!selection.isEmpty());
        }
    }

    private class SynchronizeProject
    extends SelectionProviderAction {
        protected SynchronizeProject(ISelectionProvider provider) {
            super(provider, Messages.TranslatedProjectSection_Synchronize_project);
            this.setImageDescriptor(V8UiPlugin.getImageDescriptor("com.e1c.langtool.v8.dt.ui/obj16/translations_run.png"));
            this.setEnabled(false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (TranslatedProjectSection.this.editor.isDirty()) {
                if (MessageDialog.open((int)3, (Shell)TranslatedProjectSection.this.editor.getEditorSite().getShell(), (String)Messages.TranslatedProjectSection_Save_and_synchronize, (String)Messages.TranslatedProjectSection_Save_settings_and_synchronize_selected_projects, (int)0, (String[])new String[]{Messages.TranslatedProjectSection_Save_and_synchronize_command, IDialogConstants.CANCEL_LABEL}) != 0) return;
                TranslatedProjectSection.this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            } else if (MessageDialog.open((int)3, (Shell)TranslatedProjectSection.this.editor.getEditorSite().getShell(), (String)Messages.TranslatedProjectSection_Synchronize_projects, (String)Messages.TranslatedProjectSection_Synchronize_selected_projects, (int)0, (String[])new String[]{Messages.TranslatedProjectSection_Synchronize_command, IDialogConstants.CANCEL_LABEL}) != 0) {
                return;
            }
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection == null || selection.isEmpty() || TranslatedProjectSection.this.editor.isDirty()) return;
            for (Object element : selection) {
                IProject project;
                ITranslatedProject translatedProject;
                if (!(element instanceof V8TranslatedProject)) continue;
                V8TranslatedProject v8Project = (V8TranslatedProject)element;
                String name = v8Project.getName();
                if (TranslatedProjectSection.this.isDirty() || !StringUtils.isNotEmpty((String)name) || !(translatedProject = TranslatedProjectSection.this.translatedProjectManager.getProject(project = ResourcesPlugin.getWorkspace().getRoot().getProject(name))).isTranslated()) continue;
                TranslatedProjectSection.this.syncService.startSync(translatedProject);
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.setEnabled(!selection.isEmpty());
        }
    }
}

