/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.projecteditor;

import com._1c.g5.v8.dt.common.Functions;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.ui.editor.IProjectEditor;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProjectPackage;
import com.e1c.langtool.v8.dt.ui.projecteditor.ISettingsEditingContext;
import com.e1c.langtool.v8.dt.ui.projecteditor.Messages;
import com.e1c.langtool.v8.dt.ui.projecteditor.TranslatedProjectWizard;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TranslatedProjectWizardPage
extends WizardPage
implements IWizardPage,
ICheckStateListener {
    private static final Map<ScriptVariant, String> SCRIPT_VARIANT_VARS = Map.of(ScriptVariant.ENGLISH, (String)Functions.literalToLabel().apply((Object)MdClassPackage.Literals.SCRIPT_VARIANT.getEEnumLiteral(0)), ScriptVariant.RUSSIAN, (String)Functions.literalToLabel().apply((Object)MdClassPackage.Literals.SCRIPT_VARIANT.getEEnumLiteral(1)));
    protected final IObservableMap<Object, Object> attributesMap;
    private LoadingCache<String, V8TranslateLanguage> languageCache;
    protected DataBindingContext dbc;
    private TranslateLanguageLableProvider translateLanugageLableProvider = new TranslateLanguageLableProvider();
    private CheckboxTableViewer interfaceLanguagesViewer;

    public TranslatedProjectWizardPage(IObservableMap<Object, Object> attributesMap) {
        super("Main", Messages.TranslatedProjectWizardPage_Title, TransSharedImages.getImageDescriptor((String)"com.e1c.langtool.ui/wizban/translated_project.png"));
        this.attributesMap = attributesMap;
        this.languageCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, V8TranslateLanguage>(){

            public V8TranslateLanguage load(String key) throws Exception {
                return TranslatedProjectWizardPage.this.getContext().getLanguages().stream().filter(lang -> lang.getName().equals(key)).findFirst().orElseThrow(Exception::new);
            }
        });
        this.setDescription(Messages.TranslatedProjectWizardPage_Description);
    }

    public void createControl(Composite parent) {
        this.dbc = new EMFDataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(topLevel);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)topLevel);
        topLevel.setFont(font);
        Label nameLabel = new Label(topLevel, 0);
        nameLabel.setText((String)Functions.featureToLabel().apply((Object)V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__NAME));
        Text nameText = new Text(topLevel, 2052);
        nameText.setLayoutData((Object)new GridData(768));
        Label defaulLanugageLabel = new Label(topLevel, 0);
        defaulLanugageLabel.setText((String)Functions.featureToLabel().apply((Object)V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__DEFAULT_LANGUAGE_NAME));
        ComboViewer defaulLanugageViewer = new ComboViewer(topLevel, 2048);
        defaulLanugageViewer.setContentProvider((IContentProvider)new DefaulLanugageContentProvider());
        defaulLanugageViewer.setLabelProvider((IBaseLabelProvider)this.translateLanugageLableProvider);
        defaulLanugageViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TranslatedProjectWizardPage.this.interfaceLanguagesViewer.refresh();
            }
        });
        Combo defaulLanugageCombo = defaulLanugageViewer.getCombo();
        defaulLanugageCombo.setLayoutData((Object)new GridData(768));
        Label scriptVariantLabel = new Label(topLevel, 0);
        scriptVariantLabel.setText((String)Functions.featureToLabel().apply((Object)V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__SCRIPT_VARIANT));
        ComboViewer scriptVariantCombo = new ComboViewer(topLevel, 8);
        scriptVariantCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        scriptVariantCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return SCRIPT_VARIANT_VARS.get(element);
            }
        });
        scriptVariantCombo.setInput((Object)ScriptVariant.values());
        Label interfaceLanguagesLabel = new Label(topLevel, 0);
        interfaceLanguagesLabel.setText((String)Functions.featureToLabel().apply((Object)V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__INTERFACE_LANGUAGE_NAMES));
        this.interfaceLanguagesViewer = CheckboxTableViewer.newCheckList((Composite)topLevel, (int)68354);
        this.interfaceLanguagesViewer.setLabelProvider((IBaseLabelProvider)this.translateLanugageLableProvider);
        this.interfaceLanguagesViewer.addCheckStateListener((ICheckStateListener)this);
        this.interfaceLanguagesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.interfaceLanguagesViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return element != null && element.equals(TranslatedProjectWizardPage.this.getDefaultLanguage());
            }

            public boolean isChecked(Object element) {
                if (element == null) {
                    return false;
                }
                if (element.equals(TranslatedProjectWizardPage.this.getDefaultLanguage())) {
                    return true;
                }
                Object value = TranslatedProjectWizardPage.this.attributesMap.get((Object)"interface_languages");
                if (value instanceof Set) {
                    Set languages = (Set)value;
                    TranslateLanguage lang = (TranslateLanguage)element;
                    return languages.contains(lang.getName());
                }
                return false;
            }
        });
        Table interfaceLanguagesTable = this.interfaceLanguagesViewer.getTable();
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 150).applyTo((Control)interfaceLanguagesTable);
        interfaceLanguagesTable.setLayoutData((Object)new GridData(1808));
        interfaceLanguagesTable.setFont(font);
        defaulLanugageViewer.setInput(this.getContext().getLanguages().stream().map(TranslateLanguage::getName).collect(Collectors.toList()));
        this.interfaceLanguagesViewer.setInput(this.getContext().getLanguages());
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)nameText), Observables.observeMapEntry(this.attributesMap, (Object)V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__NAME));
        UpdateValueStrategy defaulLanguageModelToTargetStrategy = new UpdateValueStrategy();
        defaulLanguageModelToTargetStrategy.setConverter((IConverter)new DefaulLanguageModelToTargetConverter());
        UpdateValueStrategy defaulLanguageTargetToModelStrategy = new UpdateValueStrategy();
        defaulLanguageTargetToModelStrategy.setConverter((IConverter)new DefaulLanguageTargetToModelConverter());
        this.dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(String.class).observe((Viewer)defaulLanugageViewer), Observables.observeMapEntry(this.attributesMap, (Object)V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__DEFAULT_LANGUAGE_NAME), defaulLanguageTargetToModelStrategy, defaulLanguageModelToTargetStrategy);
        UpdateValueStrategy scriptVariantModelToTargetStrategy = new UpdateValueStrategy();
        scriptVariantModelToTargetStrategy.setConverter((IConverter)new ScriptVariantModelToTargetConverter());
        UpdateValueStrategy scriptVariantTargetToModelStrategy = new UpdateValueStrategy();
        scriptVariantTargetToModelStrategy.setConverter((IConverter)new ScriptVariantTargetToModelConverter());
        this.dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(ScriptVariant.class).observe((Viewer)scriptVariantCombo), Observables.observeMapEntry(this.attributesMap, (Object)V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__SCRIPT_VARIANT), scriptVariantTargetToModelStrategy, scriptVariantModelToTargetStrategy);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
        this.setPageComplete(this.validatePage());
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getElement() instanceof V8TranslateLanguage) {
            Set value = (Set)this.attributesMap.get((Object)"interface_languages");
            if (value == null || event.getElement() == null) {
                return;
            }
            TranslateLanguage element = (TranslateLanguage)event.getElement();
            String languageName = element.getName();
            boolean state = event.getChecked();
            if (state) {
                if (!value.contains(languageName) && !this.getDefaultLanguage().equals(element)) {
                    value.add(languageName);
                }
            } else {
                value.remove(languageName);
            }
            this.interfaceLanguagesViewer.refresh();
        }
    }

    protected boolean validatePage() {
        return true;
    }

    protected TranslatedProjectWizard getWizard0() {
        return (TranslatedProjectWizard)this.getWizard();
    }

    protected ISettingsEditingContext getContext() {
        return this.getWizard0().getEditingContext();
    }

    private V8TranslateLanguage getDefaultLanguage() {
        String languageName = (String)this.attributesMap.get((Object)V8TranslatedProjectPackage.Literals.V8_TRANSLATED_PROJECT__DEFAULT_LANGUAGE_NAME);
        V8TranslateLanguage defaulLanguage = null;
        if (languageName != null) {
            try {
                defaulLanguage = (V8TranslateLanguage)this.languageCache.get((Object)languageName);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        if (defaulLanguage == null) {
            defaulLanguage = this.getContext().getDefaulProjectLanguage();
        }
        return defaulLanguage;
    }

    private class DefaulLanguageModelToTargetConverter
    implements IConverter<Object, String> {
        private DefaulLanguageModelToTargetConverter() {
        }

        public Object getFromType() {
            return String.class;
        }

        public Object getToType() {
            return String.class;
        }

        public String convert(Object fromObject) {
            if (fromObject == null) {
                return TranslatedProjectWizardPage.this.getContext().getDefaulProjectLanguage().getName();
            }
            return (String)fromObject;
        }
    }

    private class DefaulLanguageTargetToModelConverter
    implements IConverter<String, String> {
        private DefaulLanguageTargetToModelConverter() {
        }

        public Object getFromType() {
            return String.class;
        }

        public Object getToType() {
            return String.class;
        }

        public String convert(String fromObject) {
            if (fromObject != null && fromObject.equals(TranslatedProjectWizardPage.this.getContext().getDefaulProjectLanguage().getName())) {
                return null;
            }
            return fromObject;
        }
    }

    private class DefaulLanugageContentProvider
    implements IStructuredContentProvider {
        private DefaulLanugageContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList languages = Lists.newArrayList();
            Predicate<String> languageValidator = langName -> {
                V8TranslateLanguage v8Lang = null;
                try {
                    v8Lang = (V8TranslateLanguage)TranslatedProjectWizardPage.this.languageCache.get(langName);
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                return v8Lang != null && v8Lang.getOption() == TranslationOption.MODEL_AND_INTERFACE;
            };
            if (inputElement instanceof Object[]) {
                Object[] objectArray = (Object[])inputElement;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object language = objectArray[n2];
                    if (language instanceof String && languageValidator.test((String)language)) {
                        languages.add(language);
                    }
                    ++n2;
                }
                return languages.toArray();
            }
            if (inputElement instanceof Collection) {
                for (Object language : (Collection)inputElement) {
                    if (!(language instanceof String) || !languageValidator.test((String)language)) continue;
                    languages.add(language);
                }
            }
            return languages.toArray();
        }
    }

    private class ScriptVariantModelToTargetConverter
    implements IConverter<Object, ScriptVariant> {
        private ScriptVariantModelToTargetConverter() {
        }

        public Object getFromType() {
            return ScriptVariant.class;
        }

        public Object getToType() {
            return ScriptVariant.class;
        }

        public ScriptVariant convert(Object fromObject) {
            if (fromObject == null && TranslatedProjectWizardPage.this.getContext().getContext() instanceof IProjectEditor) {
                return ((IProjectEditor)TranslatedProjectWizardPage.this.getContext().getContext()).getV8Project().getScriptVariant();
            }
            return (ScriptVariant)fromObject;
        }
    }

    private class ScriptVariantTargetToModelConverter
    implements IConverter<ScriptVariant, ScriptVariant> {
        private ScriptVariantTargetToModelConverter() {
        }

        public Object getFromType() {
            return ScriptVariant.class;
        }

        public Object getToType() {
            return ScriptVariant.class;
        }

        public ScriptVariant convert(ScriptVariant fromObject) {
            if (fromObject != null && TranslatedProjectWizardPage.this.getContext().getContext() instanceof IProjectEditor && ((IProjectEditor)TranslatedProjectWizardPage.this.getContext().getContext()).getV8Project().getScriptVariant().equals((Object)fromObject)) {
                return null;
            }
            return fromObject;
        }
    }

    private class TranslateLanguageLableProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private TranslateLanguageLableProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof V8TranslateLanguage) {
                V8TranslateLanguage language = (V8TranslateLanguage)element;
                String lable = (String)language.getSynonym().get((Object)language.getLanguageCode());
                return lable == null ? language.getName() : lable;
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }
    }
}

