/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ui.storage;

import com.e1c.langtool.storage.IStorageSettingsChangeListener;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.v8.dt.ui.storage.Messages;
import com.e1c.langtool.v8.dt.ui.storage.StorageTableLableProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class StoragePropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
ICheckStateListener {
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    private Button upButton;
    private Button downButton;
    private Button setDefaultButton;
    private CheckboxTableViewer viewer = null;
    private ITableLabelProvider labelProvider = new StorageTableLableProvider(() -> this.defaultEditingStorageId);
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StoragePropertyPage.this.handleButtonPressed((Button)e.widget);
        }
    };
    private boolean userHasMadeChanges = false;
    private StorageID defaultEditingStorageId;
    private Set<StorageID> storagesIds = new HashSet<StorageID>();
    private final IStorageSettingsChangeListener settingsChangeListener = (project, projectClosed) -> {
        if (this.viewer.getControl().isDisposed() || this.viewer.getControl().getDisplay().isDisposed()) {
            this.storageSettingsManager.removeChangeListener(this.settingsChangeListener);
        } else if (project.equals((Object)this.getInputProject()) && !this.viewer.getControl().isDisposed() && !this.viewer.getControl().getDisplay().isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(() -> {
                if (!this.viewer.getControl().isDisposed() && !this.viewer.getControl().getDisplay().isDisposed()) {
                    this.addStoragesToTable();
                    this.handleTableSelectionChanged();
                }
            });
        }
    };

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(1808));
        Label description = new Label(topLevel, 64);
        description.setText(Messages.StoragePropertyPage_Configure_translation_storages_for_the_project);
        description.setLayoutData((Object)new GridData(768));
        description.setFont(font);
        Composite tableAndButtons = new Composite(topLevel, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)tableAndButtons, (int)68354);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table storageTable = this.viewer.getTable();
        storageTable.setLayoutData((Object)new GridData(1808));
        storageTable.setFont(font);
        storageTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StoragePropertyPage.this.handleTableSelectionChanged();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setFont(font);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.setDefaultButton = this.createButton(buttonArea, Messages.StoragePropertyPage_Set_default);
        new Label(buttonArea, 16384);
        this.upButton = this.createButton(buttonArea, Messages.StoragePropertyPage_Up);
        this.downButton = this.createButton(buttonArea, Messages.StoragePropertyPage_Down);
        this.addStoragesToTable();
        this.storageSettingsManager.addChangeListener(this.settingsChangeListener);
        return topLevel;
    }

    public void dispose() {
        this.storageSettingsManager.removeChangeListener(this.settingsChangeListener);
        super.dispose();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.userHasMadeChanges = true;
        Object element = event.getElement();
        boolean checked = event.getChecked();
        if (element instanceof StorageSettings) {
            if (checked) {
                this.storagesIds.add(((StorageSettings)element).getStorageId());
            } else {
                this.storagesIds.remove(((StorageSettings)element).getStorageId());
            }
        }
    }

    public boolean performOk() {
        if (!this.userHasMadeChanges) {
            return super.performOk();
        }
        this.userHasMadeChanges = false;
        IProject project = this.getInputProject();
        List<StorageSettings> input = this.getInput();
        List storageSettings = input.stream().filter(e -> this.storagesIds.contains(e.getStorageId())).collect(Collectors.toList());
        if (project != null && !input.isEmpty()) {
            this.storageSettingsManager.saveReadSettings(project, storageSettings);
        }
        if (!(project == null || this.defaultEditingStorageId == null || this.storagesIds.contains(this.defaultEditingStorageId) || storageSettings.isEmpty() || this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId().equals((Object)this.defaultEditingStorageId))) {
            this.defaultEditingStorageId = ((StorageSettings)storageSettings.get(0)).getStorageId();
        }
        this.storageSettingsManager.saveDefaultEditingStorageId(project, this.defaultEditingStorageId);
        return super.performOk();
    }

    private IProject getInputProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        Object resource = element.getAdapter(IResource.class);
        if (resource instanceof IProject) {
            return (IProject)resource;
        }
        return null;
    }

    protected List<StorageSettings> getInput() {
        Table storageTable = this.viewer.getTable();
        ArrayList settings = Lists.newArrayList();
        int i = 0;
        while (i < storageTable.getItemCount()) {
            TableItem item = storageTable.getItem(i);
            StorageSettings storage = (StorageSettings)item.getData();
            settings.add(storage);
            ++i;
        }
        return settings;
    }

    private void addStoragesToTable() {
        IProject project = this.getInputProject();
        if (project == null) {
            return;
        }
        ProjectStorageSettings settings = this.storageSettingsManager.getSettingsOrDefault(project);
        this.storagesIds = new HashSet<StorageID>(settings.getReadStorageIds());
        ArrayList<StorageSettings> allStorages = new ArrayList<StorageSettings>(settings.getReadStorageSettings());
        for (Map.Entry entry : settings.allStorageSettings().entrySet()) {
            if (this.storagesIds.contains(entry.getKey())) continue;
            allStorages.add((StorageSettings)entry.getValue());
        }
        this.defaultEditingStorageId = settings.getEdit().getRules().isEmpty() && settings.getEdit().getStorageIDs().size() == 1 ? (StorageID)settings.getEdit().getStorageIDs().get(0) : settings.getEdit().getStorageId();
        this.viewer.setInput(allStorages);
        for (StorageSettings storageSetting : allStorages) {
            this.viewer.setChecked((Object)storageSetting, this.storagesIds.contains(storageSetting.getStorageId()));
        }
    }

    private void handleTableSelectionChanged() {
        Table storageTable = this.viewer.getTable();
        TableItem[] items = storageTable.getSelection();
        boolean enableSetDefault = false;
        boolean enableUp = false;
        boolean enableDown = false;
        if (items != null) {
            boolean validSelection;
            enableSetDefault = validSelection = items.length > 0;
            enableUp = validSelection;
            enableDown = validSelection;
            int[] indices = storageTable.getSelectionIndices();
            int max = storageTable.getItemCount();
            if (indices.length > 0) {
                enableUp = indices[0] != 0;
                enableDown = indices[indices.length - 1] < max - 1;
            }
            int i = 0;
            while (i < items.length) {
                StorageSettings settings;
                TableItem item = items[i];
                Object data = item.getData();
                if (data instanceof StorageSettings && this.defaultEditingStorageId != null && ((settings = (StorageSettings)data).isReadOnly() || settings.getStorageId().equals((Object)this.defaultEditingStorageId))) {
                    enableSetDefault = false;
                }
                ++i;
            }
        }
        this.setDefaultButton.setEnabled(enableSetDefault);
        this.upButton.setEnabled(enableUp);
        this.downButton.setEnabled(enableDown);
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(false);
        button.addSelectionListener(this.buttonListener);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return button;
    }

    private void handleButtonPressed(Button button) {
        if (button == this.setDefaultButton) {
            this.handleSetDefaultButtonPressed();
        } else if (button == this.upButton) {
            this.moveSelectionUp();
        } else if (button == this.downButton) {
            this.moveSelectionDown();
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        this.handleTableSelectionChanged();
        this.viewer.getTable().setFocus();
    }

    private void move(TableItem item, int index) {
        this.userHasMadeChanges = true;
        Object data = item.getData();
        item.dispose();
        this.viewer.insert(data, index);
        this.viewer.setChecked(data, this.isEnabled(data));
    }

    private void moveSelectionDown() {
        Table storageTable = this.viewer.getTable();
        int[] indices = storageTable.getSelectionIndices();
        if (indices.length < 1) {
            return;
        }
        int[] newSelection = new int[indices.length];
        int max = storageTable.getItemCount() - 1;
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            if (index < max) {
                this.move(storageTable.getItem(index), index + 1);
                newSelection[i] = index + 1;
            }
            --i;
        }
        storageTable.setSelection(newSelection);
    }

    private void moveSelectionUp() {
        Table storageTable = this.viewer.getTable();
        int[] indices = storageTable.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index > 0) {
                this.move(storageTable.getItem(index), index - 1);
                newSelection[i] = index - 1;
            }
            ++i;
        }
        storageTable.setSelection(newSelection);
    }

    private void handleSetDefaultButtonPressed() {
        if (!this.viewer.getStructuredSelection().isEmpty() && this.viewer.getStructuredSelection().getFirstElement() instanceof StorageSettings) {
            StorageSettings settings = (StorageSettings)this.viewer.getStructuredSelection().getFirstElement();
            this.viewer.setChecked((Object)settings, true);
            this.defaultEditingStorageId = settings.getStorageId();
            this.viewer.refresh();
            this.userHasMadeChanges = true;
        }
        this.handleTableSelectionChanged();
    }

    private boolean isEnabled(Object element) {
        if (element instanceof StorageSettings) {
            return this.storagesIds.contains(((StorageSettings)element).getStorageId());
        }
        return false;
    }
}

