/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.internal.stat.AsyncRecomputer;
import com.e1c.langtool.internal.stat.StatPlugin;
import com.e1c.langtool.internal.stat.db.MetricPercentage;
import com.e1c.langtool.internal.stat.db.MetricValues;
import com.e1c.langtool.internal.stat.db.ProjectMetricStorage;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.ChangeType;
import com.e1c.langtool.stat.ExportFormat;
import com.e1c.langtool.stat.IExporterRegistry;
import com.e1c.langtool.stat.IStatisticsExporter;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsChangeEvent;
import com.e1c.langtool.stat.StatisticsChangeListener;
import com.e1c.langtool.stat.StatisticsManager;
import com.e1c.langtool.stat.StatisticsProvider;
import com.e1c.langtool.stat.StatisticsService;
import com.e1c.langtool.stat.TranslationProgress;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.annotation.NonNull;

public class CompositeStatisticsManager
implements StatisticsManager {
    private final IProject project;
    private final ProjectMetricStorage storage;
    private final StatisticsService statisticsService;
    private final ITranslatingProjectManager translatingProjectManager;
    private final AsyncRecomputer recomputer;
    private final IStorageValueChangedListener storageListener = this::storageTranslationChanged;
    private final ListenerList<StatisticsChangeListener> changeListeners = new ListenerList();
    private final IExporterRegistry exporterRegistry;

    public CompositeStatisticsManager(IProject project, ProjectMetricStorage storage, StatisticsService statisticsService, ITranslatingProjectManager translatingProjectManager, ITranslationStorageManager storageManager, AsyncRecomputer recomputer, IExporterRegistry exporterRegistry) {
        this.project = project;
        this.storage = storage;
        this.statisticsService = statisticsService;
        this.translatingProjectManager = translatingProjectManager;
        this.recomputer = recomputer;
        this.exporterRegistry = exporterRegistry;
        @NonNull IProjectTranslationReader reader = storageManager.getTranslationReader(project);
        reader.addValueChangedListener(this.storageListener);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void updateProjectStatistic(Statistics statistics) {
        ITranslatingProject translating = this.translatingProjectManager.getProject(this.getProject());
        Collection<Metric> metrics = this.getMetrics();
        MetricValues values = new MetricValues(this.getStatisticValues(metrics, statistics));
        this.storage.setTotalValues(values);
        for (TranslateLanguage language : translating.getInterfaceLanguages()) {
            values = new MetricValues(this.getStatisticValues(metrics, statistics, language));
            this.storage.setTotalValues(language, values);
            MetricPercentage percentage = new MetricPercentage(this.getStatisticPercentage(metrics, statistics, language));
            this.storage.setTotalPercentage(language, percentage);
        }
        StatisticsChangeEvent event = new StatisticsChangeEvent(this.project, ChangeType.UPDATE, statistics);
        this.fireChange(event);
    }

    @Override
    public void updateProjectLanguageStatistic(TranslateLanguage language, Statistics statistics) {
        Collection<Metric> metrics = this.getMetrics();
        MetricValues values = new MetricValues(this.getStatisticValues(metrics, statistics, language));
        this.storage.setTotalValues(language, values);
        MetricPercentage percentage = new MetricPercentage(this.getStatisticPercentage(metrics, statistics, language));
        this.storage.setTotalPercentage(language, percentage);
    }

    @Override
    public void updateFullStatistic(IPath path, Statistics statistics) {
        ITranslatingProject translating = this.translatingProjectManager.getProject(this.getProject());
        Collection<Metric> metrics = this.getMetrics();
        MetricValues values = new MetricValues(this.getStatisticValues(metrics, statistics));
        boolean changed = this.storage.putValues(path, values) != null;
        for (TranslateLanguage language : translating.getInterfaceLanguages()) {
            changed |= this.storage.putValues(path, language, values = new MetricValues(this.getStatisticValues(metrics, statistics, language))) != null;
            MetricPercentage percentage = new MetricPercentage(this.getStatisticPercentage(metrics, statistics, language));
            changed |= this.storage.putPercentage(path, language, percentage) != null;
        }
        ChangeType type = changed ? ChangeType.UPDATE : ChangeType.ADD;
        StatisticsChangeEvent event = new StatisticsChangeEvent(this.project, type, path, statistics);
        this.fireChange(event);
    }

    @Override
    public void updateLanguageStatistic(IPath path, TranslateLanguage language, Statistics statistics) {
        Collection<Metric> metrics = this.getMetrics();
        MetricValues values = new MetricValues(this.getStatisticValues(metrics, statistics, language));
        boolean changed = this.storage.putValues(path, language, values) != null;
        MetricPercentage percentage = new MetricPercentage(this.getStatisticPercentage(metrics, statistics, language));
        ChangeType type = (changed |= this.storage.putPercentage(path, language, percentage) != null) ? ChangeType.UPDATE : ChangeType.ADD;
        StatisticsChangeEvent event = new StatisticsChangeEvent(this.project, type, path, language, statistics);
        this.fireChange(event);
    }

    @Override
    public void removeStatistic() {
        if (this.storage.delete()) {
            StatisticsChangeEvent event = new StatisticsChangeEvent(this.project, ChangeType.REMOVE);
            this.fireChange(event);
        }
    }

    @Override
    public void removeStatistic(TranslateLanguage language) {
        if (this.storage.delete(language)) {
            StatisticsChangeEvent event = new StatisticsChangeEvent(this.project, ChangeType.REMOVE, language);
            this.fireChange(event);
        }
    }

    @Override
    public void removeStatistic(IPath path) {
        ITranslatingProject translating = this.translatingProjectManager.getProject(this.getProject());
        boolean changed = this.storage.removeValues(path) != null;
        for (TranslateLanguage language : translating.getInterfaceLanguages()) {
            changed |= this.storage.removeValues(path, language) != null;
            changed |= this.storage.removePercentage(path, language) != null;
        }
        if (changed) {
            StatisticsChangeEvent event = new StatisticsChangeEvent(this.project, ChangeType.REMOVE, path);
            this.fireChange(event);
        }
    }

    @Override
    public void removeStatistic(IPath path, TranslateLanguage language) {
        boolean changed = this.storage.removeValues(path, language) != null;
        if (changed |= this.storage.removePercentage(path, language) != null) {
            StatisticsChangeEvent event = new StatisticsChangeEvent(this.project, ChangeType.REMOVE, path, language);
            this.fireChange(event);
        }
    }

    @Override
    public void startRecomputeFullStatistic() {
        this.recomputer.addToQueue(this.project, this.project.getProjectRelativePath());
        this.recomputer.scheduleComputeFullStat();
    }

    @Override
    public void exportStatistics(Path path, String type, boolean untranslatedOnly) throws IOException {
        ExportFormat exportFormat;
        String fileExtension = CompositeStatisticsManager.getExtension(path.toString()).toLowerCase();
        try {
            exportFormat = ExportFormat.valueOf(fileExtension.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unsupported file format: %s", fileExtension), e);
        }
        IStatisticsExporter exporter = this.exporterRegistry.getExporter(exportFormat);
        if (exporter == null) {
            throw new IllegalStateException(String.format("Exporter for format %s not found", new Object[]{exportFormat}));
        }
        List languages = this.translatingProjectManager.getProject(this.project).getInterfaceLanguages();
        StatisticsProvider provider = this.statisticsService.getProvider(this.project);
        Collection<Metric> metrics = this.statisticsService.getMetrics();
        if (type != null && !type.equals("interface-model-place-count")) {
            metrics = metrics.stream().filter(metric -> metric.getID().equalsIgnoreCase(type)).toList();
        }
        exporter.export(path, provider, languages, metrics, untranslatedOnly);
    }

    public void addStatisticChangeListener(StatisticsChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    public void removeStatisticChangeListener(StatisticsChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    protected void fireChange(StatisticsChangeEvent event) {
        for (StatisticsChangeListener l : this.changeListeners) {
            try {
                SafeRunner.run(() -> l.statisticsChanged(event));
            }
            catch (Throwable e) {
                StatPlugin.logError(e);
            }
        }
    }

    private Collection<Metric> getMetrics() {
        return this.statisticsService.getMetrics();
    }

    private Map<String, TranslationProgress> getStatisticValues(Collection<Metric> metrics, Statistics statistics) {
        HashMap<String, TranslationProgress> result = new HashMap<String, TranslationProgress>();
        for (Metric metric : metrics) {
            int value = statistics.getMetricValue(metric);
            if (value <= 0) continue;
            result.put(metric.getID(), new TranslationProgress(value));
        }
        return result;
    }

    private Map<String, TranslationProgress> getStatisticValues(Collection<Metric> metrics, Statistics statistics, TranslateLanguage language) {
        HashMap<String, TranslationProgress> result = new HashMap<String, TranslationProgress>();
        for (Metric metric : metrics) {
            TranslationProgress progress = statistics.getMetricValue(metric, language);
            if (progress == null || progress.getTranslatedCount() <= 0 && progress.getUntranslatedKeys().isEmpty()) continue;
            result.put(metric.getID(), progress);
        }
        return result;
    }

    private Map<String, Float> getStatisticPercentage(Collection<Metric> metrics, Statistics statistics, TranslateLanguage language) {
        HashMap<String, Float> result = new HashMap<String, Float>();
        for (Metric metric : metrics) {
            float value = statistics.getMetricPercentage(metric, language);
            if (!(value > 0.0f)) continue;
            result.put(metric.getID(), Float.valueOf(value));
        }
        return result;
    }

    private void storageTranslationChanged(StorageValueChangeEvent event) {
        TranslateLanguage language = event.getLanguage();
        IPath path = null;
        if (event.getTranslationKey() instanceof ContextTranslationKey) {
            path = ((ContextTranslationKey)event.getTranslationKey()).getResourceId();
        }
        if (path == null && language == null) {
            this.removeStatistic();
        } else if (path == null) {
            this.removeStatistic(language);
        } else if (language == null) {
            this.removeStatistic(path);
            this.recomputer.addToQueue(this.project, path);
            this.recomputer.scheduleCompute();
        } else {
            this.removeStatistic(path, language);
            this.recomputer.addToQueue(this.project, path);
            this.recomputer.scheduleCompute();
        }
    }

    private static final String getExtension(String fileName) {
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex != -1) {
            return fileName.substring(extensionIndex + 1);
        }
        return "";
    }
}

