/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.internal.stat.db.ProjectMetricStorage;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsProvider;
import com.e1c.langtool.stat.StatisticsService;
import com.e1c.langtool.stat.TranslationProgress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

public class CompositeStatisticsProvider
implements StatisticsProvider {
    private final IProject project;
    private final ProjectMetricStorage storage;
    private final StatisticsService statisticService;
    private final Statistics projectStat = new Statistics(){

        @Override
        public int getMetricValue(Metric metric) {
            TranslationProgress progress = CompositeStatisticsProvider.this.storage.getTotalValues().getValues().getOrDefault(metric.getID(), new TranslationProgress());
            return progress.getTranslatedCount();
        }

        @Override
        public TranslationProgress getMetricValue(Metric metric, TranslateLanguage language) {
            return CompositeStatisticsProvider.this.storage.getTotalValues(language).getValues().getOrDefault(metric.getID(), new TranslationProgress());
        }

        @Override
        public float getMetricPercentage(Metric metric, TranslateLanguage language) {
            return CompositeStatisticsProvider.this.storage.getTotalPercentage(language).getPercentage().getOrDefault(metric.getID(), Float.valueOf(0.0f)).floatValue();
        }
    };
    private static final Statistics EMPTY_STAT = new Statistics(){

        @Override
        public int getMetricValue(Metric metric) {
            return 0;
        }

        @Override
        public TranslationProgress getMetricValue(Metric metric, TranslateLanguage language) {
            return new TranslationProgress();
        }

        @Override
        public float getMetricPercentage(Metric metric, TranslateLanguage language) {
            return 0.0f;
        }
    };

    public CompositeStatisticsProvider(IProject project, ProjectMetricStorage storage, StatisticsService statisticService) {
        this.statisticService = statisticService;
        this.storage = storage;
        this.project = project;
    }

    @Override
    public Statistics getStatistic(final IPath path) {
        if (path == null || path.isEmpty() || path.isRoot()) {
            return EMPTY_STAT;
        }
        return new Statistics(){

            @Override
            public int getMetricValue(Metric metric) {
                Map<String, TranslationProgress> values = CompositeStatisticsProvider.this.storage.getValues(path).getValues();
                TranslationProgress progress = values.getOrDefault(metric.getID(), new TranslationProgress());
                return progress.getTranslatedCount();
            }

            @Override
            public TranslationProgress getMetricValue(Metric metric, TranslateLanguage language) {
                return CompositeStatisticsProvider.this.storage.getValues(path, language).getValues().getOrDefault(metric.getID(), new TranslationProgress());
            }

            @Override
            public float getMetricPercentage(Metric metric, TranslateLanguage language) {
                return CompositeStatisticsProvider.this.storage.getPercentage(path, language).getPercentage().getOrDefault(metric.getID(), Float.valueOf(0.0f)).floatValue();
            }
        };
    }

    @Override
    public @NonNull Statistics getGroupStatistic(final @NonNull IPath path) {
        if (path.isEmpty() || path.isRoot()) {
            return EMPTY_STAT;
        }
        return new Statistics(){

            @Override
            public int getMetricValue(Metric metric) {
                TranslationProgress progress = CompositeStatisticsProvider.this.storage.getValues(path).getValues().getOrDefault(metric.getID(), new TranslationProgress());
                return progress.getTranslatedCount();
            }

            @Override
            public TranslationProgress getMetricValue(Metric metric, TranslateLanguage language) {
                return CompositeStatisticsProvider.this.storage.getValues(path, language).getValues().getOrDefault(metric.getID(), new TranslationProgress());
            }

            @Override
            public float getMetricPercentage(Metric metric, TranslateLanguage language) {
                return CompositeStatisticsProvider.this.storage.getPercentage(path, language).getPercentage().getOrDefault(metric.getID(), Float.valueOf(0.0f)).floatValue();
            }
        };
    }

    @Override
    public Statistics getTotalValueStatistic() {
        if (Job.getJobManager().find((Object)"Statistics").length > 0) {
            return this.projectStat;
        }
        if (this.storage.isEmpty()) {
            this.statisticService.getManager(this.project).startRecomputeFullStatistic();
        }
        return this.projectStat;
    }

    @Override
    public Collection<Metric> getAvailableMetrics() {
        return this.statisticService.getMetrics();
    }

    @Override
    public @NonNull Iterator<Pair<IPath, Statistics>> statisticsIterator() {
        return new Iterator<Pair<IPath, Statistics>>(){
            private final Iterator<IPath> iterator;
            {
                this.iterator = CompositeStatisticsProvider.this.storage.resourceIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Pair<IPath, Statistics> next() {
                IPath path = this.iterator.next();
                return new Pair((Object)path, (Object)CompositeStatisticsProvider.this.getStatistic(path));
            }
        };
    }
}

