/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat;

import com.e1c.langtool.internal.stat.StatPlugin;
import com.e1c.langtool.stat.GroupProvider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

@Singleton
public class GroupProviderRegistry {
    private static final String ATT_COMPUTER = "groupProvider";
    private static final String ATT_CLASS = "class";
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.stat.metricComputer";
    private volatile Collection<GroupProvider> providers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GroupProvider> get() {
        if (this.providers == null) {
            GroupProviderRegistry groupProviderRegistry = this;
            synchronized (groupProviderRegistry) {
                if (this.providers != null) {
                    return this.providers;
                }
                this.providers = this.loadProviders();
            }
        }
        return this.providers;
    }

    private Collection<GroupProvider> loadProviders() {
        IConfigurationElement[] config;
        ArrayList<GroupProvider> groupProviders = new ArrayList<GroupProvider>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals(ATT_COMPUTER)) {
                try {
                    GroupProvider provider = (GroupProvider)ce.createExecutableExtension(ATT_CLASS);
                    groupProviders.add(provider);
                }
                catch (Exception e) {
                    StatPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.e1c.langtool.stat", "Couldn't instantiate extension", (Throwable)e));
                }
            }
            ++n2;
        }
        return Collections.unmodifiableCollection(groupProviders);
    }
}

