/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.adapters;

import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsProvider;
import com.e1c.langtool.stat.StatisticsService;
import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;

public class FileStatisticAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] CLASSES = new Class[]{Statistics.class};
    private final StatisticsService statisticService;

    @Inject
    public FileStatisticAdapterFactory(StatisticsService statisticService) {
        this.statisticService = statisticService;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (!(adaptableObject instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)adaptableObject;
        if (adapterType == Statistics.class) {
            @NonNull StatisticsProvider provider = this.statisticService.getProvider(file.getProject());
            return adapterType.cast(provider.getStatistic(file.getProjectRelativePath()));
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return CLASSES;
    }
}

