/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.adapters;

import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsProvider;
import com.e1c.langtool.stat.StatisticsService;
import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;

public class ProjectStatisticAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] CLASSES = new Class[]{Statistics.class};
    private final StatisticsService statisticService;

    @Inject
    public ProjectStatisticAdapterFactory(StatisticsService statisticService) {
        this.statisticService = statisticService;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (!(adaptableObject instanceof IProject)) {
            return null;
        }
        IProject project = (IProject)adaptableObject;
        if (adapterType == Statistics.class) {
            @NonNull StatisticsProvider provider = this.statisticService.getProvider(project);
            return adapterType.cast(provider.getTotalValueStatistic());
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return CLASSES;
    }
}

