/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.computer;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.stat.computer.InterfaceModelPlaceCountMetric;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.StatisticsComputer;
import com.e1c.langtool.stat.TranslationProgress;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.annotation.NonNull;

public final class ComputerInterfaceModelPlaces
implements StatisticsComputer {
    @Inject
    private ITranslationStorageManager storageManager;

    @Override
    public Metric getMetric() {
        return InterfaceModelPlaceCountMetric.getInstance();
    }

    @Override
    public int computeBaseValue(IProject project, Collection<ContextTranslationKey> keys) {
        return keys.size();
    }

    @Override
    public TranslationProgress computeTranslatedValue(IProject project, Collection<ContextTranslationKey> keys, TranslateLanguage language) {
        HashSet<String> untranslatedKeys = new HashSet<String>();
        @NonNull IProjectTranslationReader reader = this.storageManager.getTranslationReader(project);
        int count = 0;
        for (ContextTranslationKey key : keys) {
            FeatureSettings featureSettings = key.getFeatureSettings();
            if (!TranslationUtils.isValidFeatureForLanguage((FeatureSettings)featureSettings, (TranslateLanguage)language)) continue;
            String translation = reader.getStoredTranslation((TranslationKey)key, language, new ITranslationStorageProvider.Storage.Type[0]);
            if (StringUtils.isNotEmpty((String)translation)) {
                ++count;
                continue;
            }
            untranslatedKeys.add(key.getFeatureKey().getId());
        }
        return new TranslationProgress(count, untranslatedKeys);
    }
}

