/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.db;

import com.e1c.langtool.internal.stat.db.MetricPercentage;
import com.e1c.langtool.internal.stat.db.MetricPercentageSerializer;
import com.e1c.langtool.internal.stat.db.MetricStorage;
import java.io.File;
import java.util.Map;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.Serializer;

public class LanguageMetricStorage
extends MetricStorage {
    private static final String TOTAL_PERCENTAGE = "totalPercentage";
    private Map<Long, MetricPercentage> percentage;
    private Atomic.Var<MetricPercentage> totalPercentage;

    public LanguageMetricStorage(File dbFile) {
        super(dbFile);
    }

    public MetricPercentage getTotalPercentage() {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            MetricPercentage metricPercentage = (MetricPercentage)this.totalPercentage.get();
            return metricPercentage;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public void setTotalPercentage(MetricPercentage totalPercentage) {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            this.totalPercentage.set((Object)totalPercentage);
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public MetricPercentage getMetricPercentage(long id) {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            MetricPercentage metricPercentage = this.percentage.get(id);
            return metricPercentage;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public MetricPercentage putMetricPercentage(long id, MetricPercentage data) {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            MetricPercentage result = this.percentage.put(id, data);
            if (result != null) {
                this.setTotalPercentage(new MetricPercentage());
            }
            MetricPercentage metricPercentage = result;
            return metricPercentage;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    public MetricPercentage removeMetricPercentage(long id) {
        this.checkOrOpen();
        this.initLock.readLock().lock();
        try {
            MetricPercentage result = this.percentage.remove(id);
            if (result != null) {
                this.setTotalPercentage(new MetricPercentage());
            }
            MetricPercentage metricPercentage = result;
            return metricPercentage;
        }
        finally {
            this.initLock.readLock().unlock();
        }
    }

    @Override
    protected void afterOpenDb(DB db) {
        MetricPercentageSerializer valueSerializer = new MetricPercentageSerializer();
        this.percentage = db.createTreeMap("percentage").keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).valueSerializer((Serializer)valueSerializer).valuesOutsideNodesEnable().counterEnable().makeOrGet();
        this.totalPercentage = db.exists(TOTAL_PERCENTAGE) ? db.getAtomicVar(TOTAL_PERCENTAGE) : db.createAtomicVar(TOTAL_PERCENTAGE, (Object)new MetricPercentage(), (Serializer)valueSerializer);
    }

    @Override
    protected void beforeClose() {
        this.percentage = null;
        this.totalPercentage = null;
        super.beforeClose();
    }
}

