/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.db;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.stat.db.MetricValues;
import com.e1c.langtool.stat.TranslationProgress;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mapdb.Serializer;

public class MetricValuesSerializer
implements Serializer<MetricValues>,
Serializable {
    private static final long serialVersionUID = -3342800361032291312L;

    public MetricValues deserialize(DataInput in, int available) throws IOException {
        int total = in.readInt();
        HashMap<String, TranslationProgress> result = new HashMap<String, TranslationProgress>(total);
        int i = 0;
        while (i < total) {
            String key = in.readUTF();
            int count = in.readInt();
            HashSet<String> untraslatedKeys = new HashSet<String>();
            int totalKeys = in.readInt();
            int j = 0;
            while (j < totalKeys) {
                untraslatedKeys.add(in.readUTF());
                ++j;
            }
            TranslationProgress progress = new TranslationProgress(count, untraslatedKeys);
            result.put(key, progress);
            ++i;
        }
        return new MetricValues(result);
    }

    public void serialize(DataOutput out, MetricValues data) throws IOException {
        Map<String, TranslationProgress> values = data.getValues();
        int total = values.size();
        out.writeInt(total);
        for (Map.Entry<String, TranslationProgress> entry : values.entrySet()) {
            String key = entry.getKey();
            if (StringUtils.isNullOrEmpty((String)key)) {
                key = "";
            }
            TranslationProgress value = entry.getValue();
            out.writeUTF(key);
            out.writeInt(value.getTranslatedCount());
            out.writeInt(value.getUntranslatedKeys().size());
            for (String untranslatedKey : value.getUntranslatedKeys()) {
                out.writeUTF(untranslatedKey);
            }
        }
    }

    public int fixedSize() {
        return -1;
    }
}

