/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.db;

import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.internal.stat.StatPlugin;
import com.e1c.langtool.internal.stat.db.LanguageMetricStorage;
import com.e1c.langtool.internal.stat.db.MetricPercentage;
import com.e1c.langtool.internal.stat.db.MetricValues;
import com.e1c.langtool.internal.stat.db.ResourceIndexMetricStorage;
import com.e1c.langtool.platform.TranslateLanguage;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ProjectMetricStorage {
    private static final String DB_FOLDER = "stat";
    private static final String DB_FILE_NAME_INDEX = "index.db";
    private static final MetricValues EMPTY_VALUES = new MetricValues();
    private static final MetricPercentage EMPTY_PERCENTAGE = new MetricPercentage();
    private final IProject project;
    private final Map<String, LanguageMetricStorage> languageStorages = new ConcurrentHashMap<String, LanguageMetricStorage>();
    private final ResourceIndexMetricStorage indexStorage;
    private final Collection<String> languageCodes;

    public ProjectMetricStorage(IProject project, Collection<TranslateLanguage> languages) {
        this.project = project;
        this.languageCodes = languages.stream().map(TranslateLanguage::getLanguageCode).collect(Collectors.toSet());
        this.indexStorage = new ResourceIndexMetricStorage(ProjectMetricStorage.getStorageFileIndex(project));
    }

    public MetricValues getTotalValues() {
        return this.indexStorage.getTotalValues();
    }

    public void setTotalValues(MetricValues totalValues) {
        this.indexStorage.setTotalValues(totalValues);
    }

    public MetricValues getTotalValues(TranslateLanguage language) {
        return this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).getTotalValues();
    }

    public void setTotalValues(TranslateLanguage language, MetricValues totalValues) {
        this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).setTotalValues(totalValues);
    }

    public MetricPercentage getTotalPercentage(TranslateLanguage language) {
        return this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            this.languageCodes.add((String)langCode);
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).getTotalPercentage();
    }

    public void setTotalPercentage(TranslateLanguage language, MetricPercentage totalPercentage) {
        this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            this.languageCodes.add((String)langCode);
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).setTotalPercentage(totalPercentage);
    }

    public MetricValues getValues(IPath path) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        MetricValues values = this.indexStorage.getMetricValues(id);
        if (values == null) {
            return EMPTY_VALUES;
        }
        return values;
    }

    public boolean isEmpty() {
        Map<IPath, Long> resources = this.indexStorage.getResources();
        if (Objects.isNull(resources)) {
            return true;
        }
        return resources.isEmpty();
    }

    public boolean valuesExists(IPath path) {
        if (path.isEmpty() || path.isRoot()) {
            return !this.indexStorage.getTotalValues().getValues().isEmpty();
        }
        if (Objects.isNull(this.indexStorage.getResourceId(path))) {
            return false;
        }
        return !Objects.isNull(this.indexStorage.getMetricValues(this.indexStorage.getResourceId(path)));
    }

    public MetricValues getValues(IPath path, TranslateLanguage language) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        MetricValues values = this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            this.languageCodes.add((String)langCode);
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).getMetricValues(id);
        if (values == null) {
            return EMPTY_VALUES;
        }
        return values;
    }

    public MetricValues putValues(IPath path, MetricValues values) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.indexStorage.putMetricValues(id, values);
    }

    public MetricValues putValues(IPath path, TranslateLanguage language, MetricValues values) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            this.languageCodes.add((String)langCode);
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).putMetricValues(id, values);
    }

    public MetricValues removeValues(IPath path) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.indexStorage.removeMetricValues(id);
    }

    public MetricValues removeValues(IPath path, TranslateLanguage language) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            this.languageCodes.add((String)langCode);
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).removeMetricValues(id);
    }

    public MetricPercentage getPercentage(IPath path, TranslateLanguage language) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        MetricPercentage values = this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            this.languageCodes.add((String)langCode);
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).getMetricPercentage(id);
        if (values == null) {
            return EMPTY_PERCENTAGE;
        }
        return values;
    }

    public MetricPercentage putPercentage(IPath path, TranslateLanguage language, MetricPercentage percentage) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).putMetricPercentage(id, percentage);
    }

    public MetricPercentage removePercentage(IPath path, TranslateLanguage language) {
        long id = this.indexStorage.getResourceIdOrNew(path);
        return this.languageStorages.computeIfAbsent(language.getLanguageCode(), langCode -> {
            this.languageCodes.add((String)langCode);
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
            return new LanguageMetricStorage(file);
        }).removeMetricPercentage(id);
    }

    public Iterator<IPath> resourceIterator() {
        return this.indexStorage.getResources().keySet().iterator();
    }

    public void open() {
        this.indexStorage.open();
    }

    public void close() {
        for (Map.Entry<String, LanguageMetricStorage> entry : this.languageStorages.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                StatPlugin.logError(e);
            }
        }
        this.languageStorages.clear();
        this.indexStorage.close();
    }

    public boolean delete() {
        for (Map.Entry<String, LanguageMetricStorage> entry : this.languageStorages.entrySet()) {
            entry.getValue().delete();
        }
        this.languageStorages.clear();
        this.indexStorage.delete();
        for (String languageCode : this.languageCodes) {
            File file = ProjectMetricStorage.getStorageFileLanguage(this.project, languageCode);
            if (!file.exists()) continue;
            TranslationUtils.cleanUpMabDbFiles((File)file);
        }
        return true;
    }

    public boolean delete(TranslateLanguage language) {
        LanguageMetricStorage storage = this.languageStorages.get(language.getLanguageCode());
        if (storage != null) {
            this.languageStorages.remove(language.getLanguageCode());
            storage.delete();
            return true;
        }
        File file = ProjectMetricStorage.getStorageFileLanguage(this.project, language);
        boolean result = file.exists();
        TranslationUtils.cleanUpMabDbFiles((File)file);
        return result;
    }

    private static File getStorageFileIndex(IProject project) {
        IPath path = Platform.getStateLocation((Bundle)StatPlugin.getDefault().getBundle());
        IPath folder = path.append(DB_FOLDER).append(project.getName());
        return folder.append(DB_FILE_NAME_INDEX).toFile();
    }

    private static File getStorageFileLanguage(IProject project, TranslateLanguage language) {
        return ProjectMetricStorage.getStorageFileLanguage(project, language.getLanguageCode());
    }

    private static File getStorageFileLanguage(IProject project, String languageCode) {
        IPath path = Platform.getStateLocation((Bundle)StatPlugin.getDefault().getBundle());
        IPath folder = path.append(DB_FOLDER).append(project.getName());
        return folder.append(languageCode + ".db").toFile();
    }
}

