/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.stat.export;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.stat.IStatisticsExporter;
import com.e1c.langtool.stat.Metric;
import com.e1c.langtool.stat.Statistics;
import com.e1c.langtool.stat.StatisticsPreferences;
import com.e1c.langtool.stat.StatisticsProvider;
import com.e1c.langtool.stat.StatisticsUtil;
import com.e1c.langtool.stat.TranslationProgress;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class XlsExporter
implements IStatisticsExporter {
    private static final int MAX_ROWS_PER_SHEET = 65536;

    @Override
    public void export(Path path, StatisticsProvider provider, Collection<TranslateLanguage> languages, Collection<Metric> metrics, boolean untranslatedOnly) throws IOException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path.toString()), StandardCharsets.UTF_8));){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\n");
            writer.write(" xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n");
            writer.write(" xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n");
            writer.write(" xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\n");
            writer.write(" xmlns:html=\"http://www.w3.org/TR/REC-html40\">\n");
            this.createNewSheet(writer, "Total", metrics);
            for (TranslateLanguage language : languages) {
                this.addTotalRow(writer, provider, language, metrics);
            }
            writer.write("  </Table>\n");
            writer.write(" </Worksheet>\n");
            List<Pair<IPath, Statistics>> sortedPairs = this.sortStatisticsByPath(provider.statisticsIterator());
            for (TranslateLanguage language : languages) {
                int rowCount = 0;
                int sheetIndex = 1;
                for (Pair<IPath, Statistics> pair : sortedPairs) {
                    if (rowCount % 65536 == 0) {
                        if (rowCount > 0) {
                            writer.write("  </Table>\n");
                            writer.write(" </Worksheet>\n");
                        }
                        Object sheetName = language.getName();
                        if (sheetIndex > 1) {
                            sheetName = (String)sheetName + " Part " + sheetIndex;
                        }
                        this.createNewSheet(writer, (String)sheetName, metrics);
                        ++sheetIndex;
                    }
                    IPath resourcePath = (IPath)pair.getKey();
                    Statistics statistics = (Statistics)pair.getValue();
                    StringBuilder metricBuilder = new StringBuilder();
                    HashSet<String> untranslatedKeys = new HashSet<String>();
                    for (Metric metric : metrics) {
                        int sourceValue = statistics.getMetricValue(metric);
                        TranslationProgress progress = statistics.getMetricValue(metric, language);
                        int translatedValue = progress.getTranslatedCount();
                        if (StatisticsPreferences.isEnableStatisticsUntranslatedKeys()) {
                            untranslatedKeys.addAll(progress.getUntranslatedKeys());
                        }
                        float procentTranslatedValue = statistics.getMetricPercentage(metric, language);
                        if (untranslatedOnly && (procentTranslatedValue == 100.0f || sourceValue == 0)) continue;
                        metricBuilder.append("    <Cell><Data ss:Type=\"Number\">" + sourceValue + "</Data></Cell>\n");
                        metricBuilder.append("    <Cell><Data ss:Type=\"Number\">" + translatedValue + "</Data></Cell>\n");
                        metricBuilder.append("    <Cell><Data ss:Type=\"Number\">" + StatisticsUtil.formatStatisticCount(procentTranslatedValue) + "</Data></Cell>\n");
                    }
                    if (metricBuilder.isEmpty()) continue;
                    writer.write("   <Row>\n");
                    writer.write("    <Cell><Data ss:Type=\"String\">" + resourcePath.toString() + "</Data></Cell>\n");
                    writer.write("    <Cell><Data ss:Type=\"String\">" + language.getName() + "</Data></Cell>\n");
                    String keys = "";
                    if (StatisticsPreferences.isEnableStatisticsUntranslatedKeys()) {
                        keys = String.join((CharSequence)";", untranslatedKeys);
                        if ((keys = keys.replaceAll("<", "&lt;").replaceAll(">", "&gt;")).length() > Short.MAX_VALUE) {
                            keys = keys.substring(0, Short.MAX_VALUE);
                        }
                        writer.write("    <Cell><Data ss:Type=\"String\">" + keys + "</Data></Cell>\n");
                    }
                    writer.write(metricBuilder.toString());
                    writer.write("   </Row>\n");
                    ++rowCount;
                }
                writer.write("  </Table>\n");
                writer.write(" </Worksheet>\n");
            }
            writer.write("</Workbook>");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createNewSheet(BufferedWriter writer, String sheetName, Collection<Metric> metrics) throws IOException {
        writer.write(" <Worksheet ss:Name=\"" + sheetName + "\">\n");
        writer.write("  <Table>\n");
        writer.write("   <Row>\n");
        writer.write("    <Cell><Data ss:Type=\"String\">Path</Data></Cell>\n");
        writer.write("    <Cell><Data ss:Type=\"String\">Language</Data></Cell>\n");
        if (StatisticsPreferences.isEnableStatisticsUntranslatedKeys() && !sheetName.equals("Total")) {
            writer.write("    <Cell><Data ss:Type=\"String\">Untranslated keys</Data></Cell>\n");
        }
        for (Metric metric : metrics) {
            writer.write("    <Cell><Data ss:Type=\"String\">" + metric.getTitle() + " Source</Data></Cell>\n");
            writer.write("    <Cell><Data ss:Type=\"String\">Translation</Data></Cell>\n");
            writer.write("    <Cell><Data ss:Type=\"String\">%</Data></Cell>\n");
        }
        writer.write("   </Row>\n");
    }

    private void addTotalRow(BufferedWriter writer, StatisticsProvider provider, TranslateLanguage language, Collection<Metric> metrics) throws IOException {
        writer.write("   <Row>\n");
        writer.write("    <Cell><Data ss:Type=\"String\">Total</Data></Cell>\n");
        writer.write("    <Cell><Data ss:Type=\"String\">" + language.getName() + "</Data></Cell>\n");
        for (Metric metric : metrics) {
            int sourceValue = provider.getTotalValueStatistic().getMetricValue(metric);
            int translatedValue = provider.getTotalValueStatistic().getMetricValue(metric, language).getTranslatedCount();
            float procentTranslatedValue = provider.getTotalValueStatistic().getMetricPercentage(metric, language);
            writer.write("    <Cell><Data ss:Type=\"Number\">" + sourceValue + "</Data></Cell>\n");
            writer.write("    <Cell><Data ss:Type=\"Number\">" + translatedValue + "</Data></Cell>\n");
            writer.write("    <Cell><Data ss:Type=\"Number\">" + StatisticsUtil.formatStatisticCount(procentTranslatedValue) + "</Data></Cell>\n");
        }
        writer.write("   </Row>\n");
    }
}

