/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.chart;

import com._1c.g5.v8.dt.chart.model.Chart;
import com._1c.g5.v8.dt.chart.model.ChartDataItem;
import com._1c.g5.v8.dt.chart.model.ChartPackage;
import com._1c.g5.v8.dt.chart.model.ChartReferenceBand;
import com._1c.g5.v8.dt.chart.model.ChartReferenceBands;
import com._1c.g5.v8.dt.chart.model.ChartReferenceLine;
import com._1c.g5.v8.dt.chart.model.ChartReferenceLines;
import com._1c.g5.v8.dt.chart.model.ChartScale;
import com._1c.g5.v8.dt.chart.model.ChartSeriesItem;
import com._1c.g5.v8.dt.chart.model.GaugeChartQualityBand;
import com._1c.g5.v8.dt.chart.model.GaugeChartQualityBands;
import com._1c.g5.v8.dt.chart.model.PointProperties;
import com._1c.g5.v8.dt.chart.model.RealDataItem;
import com._1c.g5.v8.dt.chart.model.SeriesProperties;
import com._1c.g5.v8.dt.chart.model.Trendline;
import com._1c.g5.v8.dt.chart.model.TrendlineArray;
import com.e1c.langtool.IBasicProcessor;
import java.util.ArrayDeque;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public abstract class ChartProcessor
implements IBasicProcessor {
    private final Collection<EObject> allObjects = new ArrayDeque<EObject>();
    protected final EObject object;
    private boolean processChildObjects = true;
    protected IProgressMonitor monitor;

    public ChartProcessor(EObject object) {
        this.object = object;
    }

    public boolean isCanceled() {
        return this.monitor == null ? false : this.monitor.isCanceled();
    }

    public boolean isProcessChildObjects() {
        return this.processChildObjects;
    }

    public void setProcessChildObjects(boolean processChildObjects) {
        this.processChildObjects = processChildObjects;
    }

    public void process(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (ChartProcessor.isSupported(this.object)) {
            this.allObjects.add(this.object);
        }
        this.doProcessInternal(this.allObjects);
    }

    protected static boolean isSupported(EObject obj) {
        EPackage objectPackage = obj.eClass().getEPackage();
        return objectPackage.equals(ChartPackage.eINSTANCE);
    }

    protected abstract <T extends EObject> void doProcess(T var1, Class<T> var2);

    private void doProcessInternal(Collection<? extends EObject> objects) {
        for (EObject eObject : objects) {
            if (this.isCanceled()) {
                return;
            }
            this.doProcessInternal(eObject);
        }
    }

    private void doProcessInternal(EObject obj) {
        if (this.isCanceled()) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Chart) {
            this.doProcessInternal((Chart)obj);
        } else if (obj instanceof ChartSeriesItem) {
            this.doProcessInternal((ChartSeriesItem)obj);
        } else if (obj instanceof PointProperties) {
            this.doProcessInternal((PointProperties)obj);
        } else if (obj instanceof RealDataItem) {
            this.doProcessInternal((RealDataItem)obj);
        } else if (obj instanceof ChartScale) {
            this.doProcessInternal((ChartScale)obj);
        } else if (obj instanceof TrendlineArray) {
            this.doProcessInternal((TrendlineArray)obj);
        } else if (obj instanceof Trendline) {
            this.doProcessInternal((Trendline)obj);
        } else if (obj instanceof SeriesProperties) {
            this.doProcessInternal((SeriesProperties)obj);
        } else if (obj instanceof ChartDataItem) {
            this.doProcessInternal((ChartDataItem)obj);
        } else if (obj instanceof GaugeChartQualityBands) {
            this.doProcessInternal((GaugeChartQualityBands)obj);
        } else if (obj instanceof GaugeChartQualityBand) {
            this.doProcessInternal((GaugeChartQualityBand)obj);
        } else if (obj instanceof ChartReferenceLines) {
            this.doProcessInternal((ChartReferenceLines)obj);
        } else if (obj instanceof ChartReferenceLine) {
            this.doProcessInternal((ChartReferenceLine)obj);
        } else if (obj instanceof ChartReferenceBands) {
            this.doProcessInternal((ChartReferenceBands)obj);
        } else if (obj instanceof ChartReferenceBand) {
            this.doProcessInternal((ChartReferenceBand)obj);
        }
    }

    private void doProcessInternal(Chart obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Chart.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getRealSeriesData());
        this.doProcessInternal(obj.getRealExSeriesData());
        this.doProcessInternal((Collection<? extends EObject>)obj.getRealPointData());
        this.doProcessInternal((Collection<? extends EObject>)obj.getRealDataItems());
        this.doProcessInternal(obj.getPointsScale());
        this.doProcessInternal(obj.getValuesScale());
        this.doProcessInternal(obj.getSeriesScale());
        this.doProcessInternal((Collection<? extends EObject>)obj.getTrendLinesArray());
        this.doProcessInternal(obj.getGaugeQualityBands());
        this.doProcessInternal(obj.getValuesReferenceLines());
        this.doProcessInternal(obj.getPointsReferenceLines());
        this.doProcessInternal(obj.getValuesReferenceBands());
        this.doProcessInternal(obj.getPointsReferenceBands());
        this.doProcessInternal(obj.getAdditionalValuesScale());
    }

    private void doProcessInternal(ChartSeriesItem obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ChartSeriesItem.class);
        this.doProcessInternal(obj.getProperties());
        this.doProcessInternal((Collection<? extends EObject>)obj.getPoints());
    }

    private void doProcessInternal(PointProperties obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, PointProperties.class);
    }

    private void doProcessInternal(RealDataItem obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, RealDataItem.class);
    }

    private void doProcessInternal(ChartScale obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ChartScale.class);
    }

    private void doProcessInternal(TrendlineArray obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, TrendlineArray.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getLine());
    }

    private void doProcessInternal(Trendline obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, Trendline.class);
    }

    private void doProcessInternal(SeriesProperties obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, SeriesProperties.class);
    }

    private void doProcessInternal(ChartDataItem obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ChartDataItem.class);
    }

    private void doProcessInternal(GaugeChartQualityBands obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GaugeChartQualityBands.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getItems());
    }

    private void doProcessInternal(GaugeChartQualityBand obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, GaugeChartQualityBand.class);
    }

    private void doProcessInternal(ChartReferenceLines obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ChartReferenceLines.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getChartReferenceLine());
    }

    private void doProcessInternal(ChartReferenceLine obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ChartReferenceLine.class);
        this.doProcessInternal((EObject)obj.getValue());
        this.doProcessInternal((EObject)obj.getDetails());
    }

    private void doProcessInternal(ChartReferenceBands obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ChartReferenceBands.class);
        this.doProcessInternal((Collection<? extends EObject>)obj.getChartReferenceBand());
    }

    private void doProcessInternal(ChartReferenceBand obj) {
        if (obj == null) {
            return;
        }
        this.doProcess(obj, ChartReferenceBand.class);
        this.doProcessInternal((EObject)obj.getDetails());
    }
}

