/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.microsoft.internal;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.ExceededQuotaException;
import com.e1c.langtool.external.InvalidAccessKeyException;
import com.e1c.langtool.external.ServiceUnavailableException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.microsoft.CorePlugin;
import com.e1c.langtool.microsoft.ITokenProvider;
import com.e1c.langtool.microsoft.Messages;
import com.e1c.langtool.microsoft.MicrosoftServiceConstants;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.apache.http.client.utils.URIBuilder;

@Singleton
public final class MicrosoftTokenGenerator
implements ITokenProvider {
    public static final String DEFAULT_TOKEN = "default";
    public static final long DEFAULT_TOKEN_TTL = Duration.ofMinutes(8L).toMillis();
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final String API_URL = "https://api.cognitive.microsoft.com/sts/v1.0/issueToken";
    private static final String PARAM_KEY = "Ocp-Apim-Subscription-Key";
    private HttpClient client;
    private volatile ITokenProvider.Token token = new ITokenProvider.Token("default", DEFAULT_TOKEN_TTL);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getActiveTokenText(String key) {
        ITokenProvider.Token token = this.getToken();
        long currentTime = System.currentTimeMillis();
        if (token == null || token.getTTL() <= currentTime) {
            MicrosoftTokenGenerator microsoftTokenGenerator = this;
            synchronized (microsoftTokenGenerator) {
                token = this.getToken();
                if (token == null || token.getTTL() <= currentTime) {
                    this.generateTokenInternal(key);
                    token = this.getToken();
                }
            }
        }
        return token.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateToken(String appKey) {
        MicrosoftTokenGenerator microsoftTokenGenerator = this;
        synchronized (microsoftTokenGenerator) {
            this.generateTokenInternal(appKey);
        }
    }

    private HttpClient getClient() {
        if (this.client == null) {
            this.client = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(5000L)).proxy(ProxySelector.getDefault()).build();
        }
        return this.client;
    }

    private synchronized void generateTokenInternal(String appKey) {
        this.token = this.token = new ITokenProvider.Token(DEFAULT_TOKEN, DEFAULT_TOKEN_TTL);
        long ttl = System.currentTimeMillis() + DEFAULT_TOKEN_TTL;
        URI uri = URI.create(API_URL);
        String authLocation = this.getAuthLocation();
        if (StringUtils.isNotEmpty((String)authLocation)) {
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setHost(authLocation + "." + uri.getHost()).setScheme(uri.getScheme()).setPath(uri.getPath());
            try {
                uri = uriBuilder.build();
            }
            catch (URISyntaxException e) {
                CorePlugin.logError(e);
            }
        }
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Transfer-Encoding", "chunked").header(PARAM_KEY, appKey).POST(HttpRequest.BodyPublishers.ofString("")).timeout(Duration.ofMillis(5000L)).build();
        try {
            HttpResponse<String> response = this.getClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 401) {
                throw new InvalidAccessKeyException(Messages.MicrosoftAccessKeyGenerator_401ExceptionMsg);
            }
            if (response.statusCode() == 403) {
                throw new ExceededQuotaException(Messages.MicrosoftAccessKeyGenerator_403ExceptionMsg);
            }
            if (response.statusCode() != 200) {
                throw new TranslationServiceException(Messages.MicrosoftAccessKeyGenerator_UnknowExcMsg + "(" + response.statusCode() + ")");
            }
            this.token = new ITokenProvider.Token(response.body(), ttl);
        }
        catch (IOException e) {
            throw new ServiceUnavailableException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TranslationServiceException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TranslationServiceException((Throwable)e);
        }
    }

    @Override
    public ITokenProvider.Token getToken() {
        return this.token;
    }

    private String getAuthLocation() {
        return CorePlugin.getDefault().getPreferenceStore().get("authApiLocation", MicrosoftServiceConstants.DEFAUTL_AUTH_API_LOCATION).trim();
    }
}

